/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import java.util.Objects;

public record Image(String url, String detail) {
    public Image {
        Objects.requireNonNull(url);
        detail = Objects.requireNonNullElse(detail, "auto");
    }

    public static Image of(String mimeType, String data) {
        return Image.of(mimeType, data, null);
    }

    public static Image of(String mimeType, String data, Detail detail) {
        Objects.requireNonNull(mimeType);
        Objects.requireNonNull(data);
        detail = Objects.requireNonNullElse(detail, Detail.AUTO);
        return new Image("data:%s;base64,%s".formatted(mimeType, data), detail.value());
    }

    public static enum Detail {
        LOW("low"),
        HIGH("high"),
        AUTO("auto");

        private String detail;

        private Detail(String detail) {
            this.detail = detail;
        }

        public String value() {
            return this.detail;
        }
    }
}

