/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool.builtin;

import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.ToolArguments;
import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolService;
import java.util.Map;
import java.util.Objects;

public class WikipediaTool
implements ExecutableTool {
    private static final String TOOL_SCHEMA_NAME = "wikipedia";
    private static final Tool TOOL_SCHEMA = Tool.of("wikipedia", "Search a query on Wikipedia.", JsonSchema.object().property("query", JsonSchema.string("Wikipedia search query")).required("query").build());
    private final ToolService toolService;

    public WikipediaTool(ToolService toolService) {
        this.toolService = Objects.requireNonNull(toolService, "ToolService can't be null");
    }

    @Override
    public String name() {
        return TOOL_SCHEMA_NAME;
    }

    @Override
    public Tool schema() {
        return TOOL_SCHEMA;
    }

    @Override
    public String execute(ToolArguments args) {
        if (Objects.isNull(args) || !args.contains("query")) {
            throw new IllegalArgumentException("query argument is required");
        }
        return this.search((String)args.get("query"));
    }

    public String search(String query) {
        Objects.requireNonNull(query, "input can't be null");
        Map<String, Object> structuredInput = Map.of("query", query);
        return this.toolService.run(ToolRequest.structuredInput("Wikipedia", structuredInput, null));
    }
}

