/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool.builtin;

import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.ToolArguments;
import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolService;
import java.util.Map;
import java.util.Objects;

@Experimental
public class WebCrawlerTool
implements ExecutableTool {
    private static final String TOOL_SCHEMA_NAME = "webcrawler";
    private static final Tool TOOL_SCHEMA = Tool.of("webcrawler", "Fetches and extracts content from a specific webpage URL. Use this tool when you need to retrieve, read, or summarize the content of a known webpage. Do not use for web search or discovering new URLs.", JsonSchema.object().property("url", JsonSchema.string("The complete URL of the webpage to fetch").pattern("^(https?://)?([\\w.-]+)\\.([a-z]{2,})(:[0-9]+)?(/[\\w./-]*)*/?$")).required("url").build());
    private final ToolService toolService;

    public WebCrawlerTool(ToolService toolService) {
        this.toolService = Objects.requireNonNull(toolService, "ToolService can't be null");
    }

    @Override
    public String name() {
        return TOOL_SCHEMA_NAME;
    }

    @Override
    public Tool schema() {
        return TOOL_SCHEMA;
    }

    @Override
    public String execute(ToolArguments args) {
        if (Objects.isNull(args) || !args.contains("url")) {
            throw new IllegalArgumentException("url argument is required");
        }
        return this.process((String)args.get("url"));
    }

    public String process(String url) {
        Objects.requireNonNull(url, "The URL must be provided");
        Map<String, Object> structuredInput = Map.of("url", url);
        String result = this.toolService.run(ToolRequest.structuredInput("WebCrawler", structuredInput));
        return (String)((Map)Json.fromJson((String)((String)Json.fromJson((String)result, String.class)), Map.class)).get("content");
    }
}

