/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool.builtin;

import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.ToolArguments;
import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.spi.json.TypeToken;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolService;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental
public class TavilySearchTool
implements ExecutableTool {
    private static final String TOOL_SCHEMA_NAME = "tavily_search";
    private static final Tool TOOL_SCHEMA = Tool.of("tavily_search", "Search for online trends, news, current events, real-time information, or research topics.", JsonSchema.object().property("query", JsonSchema.string("Tavily search query")).required("query").build());
    private final ToolService toolService;
    private final String apiKey;

    public TavilySearchTool(ToolService toolService, String apiKey) {
        this.toolService = Objects.requireNonNull(toolService, "ToolService can't be null");
        this.apiKey = Objects.requireNonNull(apiKey, "ApiKey can't be null");
    }

    @Override
    public String name() {
        return TOOL_SCHEMA_NAME;
    }

    @Override
    public Tool schema() {
        return TOOL_SCHEMA;
    }

    @Override
    public String execute(ToolArguments args) {
        if (Objects.isNull(args) || !args.contains("query")) {
            throw new IllegalArgumentException("query argument is required");
        }
        List<TavilySearchResult> result = this.search((String)args.get("query"));
        return Json.prettyPrint(result);
    }

    public List<TavilySearchResult> search(String query) {
        return this.search(query, 10);
    }

    public List<TavilySearchResult> search(String query, Integer maxResults) {
        Objects.requireNonNull(query, "input can't be null");
        maxResults = Objects.requireNonNullElse(maxResults, 10);
        Map<String, Object> structuredInput = Map.of("query", query);
        Map<String, Object> config = Map.of("apiKey", this.apiKey, "maxResults", maxResults);
        String result = this.toolService.run(ToolRequest.structuredInput("TavilySearch", structuredInput, config));
        return (List)Json.fromJson((String)result, (TypeToken)new TypeToken<List<TavilySearchResult>>(){});
    }

    public record TavilySearchResult(String title, String url, String content, Double score) {
    }
}

