/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool.builtin;

import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.ToolArguments;
import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolService;
import java.util.Map;
import java.util.Objects;

@Experimental
public class PythonInterpreterTool
implements ExecutableTool {
    private static final String TOOL_SCHEMA_NAME = "python_interpreter";
    private static final Tool TOOL_SCHEMA = Tool.of("python_interpreter", "Executes Python code and returns the console output. Use this tool for calculations, data manipulation, or visualizations.\nImportant: Only printed output (via print()) is returned. Results not explicitly printed will be ignored.", JsonSchema.object().property("code", JsonSchema.string("The Python code to execute")).required("code").build());
    private final ToolService toolService;
    private final String deploymentId;

    @Override
    public String name() {
        return TOOL_SCHEMA_NAME;
    }

    @Override
    public Tool schema() {
        return TOOL_SCHEMA;
    }

    @Override
    public String execute(ToolArguments args) {
        if (Objects.isNull(args) || !args.contains("code")) {
            throw new IllegalArgumentException("code argument is required");
        }
        return this.run((String)args.get("code"));
    }

    public PythonInterpreterTool(ToolService toolService, String pythonInterpreterDeploymentId) {
        this.toolService = Objects.requireNonNull(toolService, "ToolService can't be null");
        this.deploymentId = pythonInterpreterDeploymentId;
    }

    public String run(String code) {
        Objects.requireNonNull(code, "code can't be null");
        Map<String, Object> structuredInput = Map.of("code", code);
        Map<String, Object> config = Map.of("deploymentId", this.deploymentId);
        return this.toolService.run(ToolRequest.structuredInput("PythonInterpreter", structuredInput, config));
    }
}

