/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool;

import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.auth.Authenticator;
import com.ibm.watsonx.ai.core.factory.HttpClientFactory;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolRestClient;
import com.ibm.watsonx.ai.tool.ToolService;
import com.ibm.watsonx.ai.tool.UtilityTool;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.Objects;

final class DefaultRestClient
extends ToolRestClient {
    private static final String API_PATH = "/v1-beta/utility_agent_tools";
    private final SyncHttpClient syncHttpClient;

    DefaultRestClient(Builder builder) {
        super(builder);
        Objects.requireNonNull(this.authenticator, "authenticator is mandatory");
        this.syncHttpClient = HttpClientFactory.createSync((Authenticator)this.authenticator, (HttpClient)this.httpClient, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
    }

    @Override
    public ToolService.Resources getAll(String transactionId) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl.concat(API_PATH))).header("Accept", "application/json").timeout(this.timeout).GET();
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpResponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ToolService.Resources)Json.fromJson((String)((String)httpResponse.body()), ToolService.Resources.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UtilityTool getByName(String transactionId, String name) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "%s/%s".formatted(API_PATH, name))).header("Accept", "application/json").timeout(this.timeout).GET();
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpResponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (UtilityTool)Json.fromJson((String)((String)httpResponse.body()), UtilityTool.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String run(String transactionId, ToolRequest request) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "%s/run".formatted(API_PATH))).header("Accept", "application/json").header("Content-Type", "application/json").timeout(this.timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)request)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpResponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            Map result = (Map)Json.fromJson((String)((String)httpResponse.body()), Map.class);
            return (String)result.get("output");
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ToolRestClient.Builder {
        private Builder() {
        }

        @Override
        public DefaultRestClient build() {
            return new DefaultRestClient(this);
        }
    }
}

