/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.timeseries;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.timeseries.ForecastData;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import com.ibm.watsonx.ai.timeseries.InputSchema;
import com.ibm.watsonx.ai.timeseries.TimeSeriesParameters;
import com.ibm.watsonx.ai.timeseries.TimeSeriesProvider;
import com.ibm.watsonx.ai.timeseries.TimeSeriesRequest;
import com.ibm.watsonx.ai.timeseries.TimeSeriesRestClient;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesService
extends WatsonxService.ModelService
implements TimeSeriesProvider {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesService.class);
    private final TimeSeriesRestClient client;

    private TimeSeriesService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.authenticator(), "authenticator cannot be null");
        this.client = (TimeSeriesRestClient)((TimeSeriesRestClient.Builder)((TimeSeriesRestClient.Builder)((TimeSeriesRestClient.Builder)((TimeSeriesRestClient.Builder)((TimeSeriesRestClient.Builder)((TimeSeriesRestClient.Builder)((TimeSeriesRestClient.Builder)((TimeSeriesRestClient.Builder)TimeSeriesRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticator(builder.authenticator())).httpClient(this.httpClient)).verifySsl(this.verifySsl)).build();
    }

    @Override
    public ForecastResponse forecast(TimeSeriesRequest request) {
        if (Objects.nonNull(request.deploymentId())) {
            logger.info("The deploymentId parameter can not be used with the TimeSeriesService. Use the DeploymentService instead");
        }
        InputSchema inputSchema = request.inputSchema();
        ForecastData data = request.data();
        TimeSeriesParameters parameters = request.parameters();
        WatsonxService.ProjectService.ProjectSpace projectSpace = this.resolveProjectSpace(parameters);
        String projectId = projectSpace.projectId();
        String spaceId = projectSpace.spaceId();
        String modelId = this.modelId;
        String transactionId = null;
        ForecastRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.modelId(), this.modelId);
            transactionId = parameters.transactionId();
            requestParameters = parameters.toParameters();
        }
        ForecastRequest forecastRequest = new ForecastRequest(modelId, spaceId, projectId, data.asMap(), inputSchema, null, requestParameters);
        return this.client.forecast(transactionId, forecastRequest);
    }

    public ForecastResponse forecast(InputSchema inputSchema, ForecastData data) {
        return this.forecast(inputSchema, data, null);
    }

    public ForecastResponse forecast(InputSchema inputSchema, ForecastData data, TimeSeriesParameters parameters) {
        return this.forecast(TimeSeriesRequest.builder().inputSchema(inputSchema).data(data).parameters(parameters).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public TimeSeriesService build() {
            return new TimeSeriesService(this);
        }
    }
}

