/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing.textextraction;

import com.ibm.watsonx.ai.WatsonxRestClient;
import com.ibm.watsonx.ai.core.auth.Authenticator;
import com.ibm.watsonx.ai.core.exception.WatsonxException;
import com.ibm.watsonx.ai.core.exception.model.WatsonxError;
import com.ibm.watsonx.ai.textprocessing.DeleteFileRequest;
import com.ibm.watsonx.ai.textprocessing.ReadFileRequest;
import com.ibm.watsonx.ai.textprocessing.UploadRequest;
import com.ibm.watsonx.ai.textprocessing.textextraction.DefaultRestClient;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionDeleteParameters;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionFetchParameters;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionRequest;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionResponse;
import java.io.FileNotFoundException;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public abstract class TextExtractionRestClient
extends WatsonxRestClient {
    protected final String cosUrl;
    protected final Authenticator cosAuthenticator;

    protected TextExtractionRestClient(Builder builder) {
        super(builder);
        this.cosUrl = Objects.requireNonNull(builder.cosUrl, "cosUrl cannot be null");
        this.cosAuthenticator = Objects.requireNonNullElse(builder.cosAuthenticator, this.authenticator);
    }

    public abstract boolean deleteFile(DeleteFileRequest var1) throws FileNotFoundException;

    public abstract CompletableFuture<Boolean> asyncDeleteFile(DeleteFileRequest var1);

    public abstract String readFile(ReadFileRequest var1) throws FileNotFoundException;

    public abstract boolean upload(UploadRequest var1);

    public abstract boolean deleteExtraction(DeleteExtractionRequest var1);

    public abstract TextExtractionResponse fetchExtractionDetails(FetchExtractionDetailsRequest var1);

    public abstract TextExtractionResponse startExtraction(StartExtractionRequest var1);

    static Builder builder() {
        return ServiceLoader.load(TextExtractionRestClientBuilderFactory.class).findFirst().map(Supplier::get).orElse(DefaultRestClient.builder());
    }

    protected Exception mapIfCosFileNotFound(WatsonxException e) {
        if (e.statusCode() == 404 && e.details().isPresent()) {
            WatsonxError details = (WatsonxError)e.details().get();
            String fileNotFound = details.errors().stream().filter(error -> error.is(WatsonxError.Code.COS_FILE_NOT_FOUND)).findFirst().map(WatsonxError.Error::message).orElse(e.getMessage());
            return new FileNotFoundException(fileNotFound);
        }
        return e;
    }

    public static abstract class Builder
    extends WatsonxRestClient.Builder<TextExtractionRestClient, Builder> {
        private String cosUrl;
        private Authenticator cosAuthenticator;

        public Builder cosUrl(String cosUrl) {
            this.cosUrl = cosUrl;
            return this;
        }

        public Builder cosAuthenticator(Authenticator cosAuthenticator) {
            this.cosAuthenticator = cosAuthenticator;
            return this;
        }
    }

    public static interface TextExtractionRestClientBuilderFactory
    extends Supplier<Builder> {
    }

    public record StartExtractionRequest(String requestTrackingId, String transactionId, TextExtractionRequest textExtractionRequest) {
        public static StartExtractionRequest of(String requestTrackingId, String transactionId, TextExtractionRequest textExtractionRequest) {
            return new StartExtractionRequest(requestTrackingId, transactionId, textExtractionRequest);
        }
    }

    public record FetchExtractionDetailsRequest(String requestTrackingId, String extractionId, TextExtractionFetchParameters parameters) {
        public static FetchExtractionDetailsRequest of(String requestTrackingId, String extractionId, TextExtractionFetchParameters parameters) {
            return new FetchExtractionDetailsRequest(requestTrackingId, extractionId, parameters);
        }
    }

    public record DeleteExtractionRequest(String requestTrackingId, String extractionId, TextExtractionDeleteParameters parameters) {
        public static DeleteExtractionRequest of(String requestTrackingId, String extractionId, TextExtractionDeleteParameters parameters) {
            return new DeleteExtractionRequest(requestTrackingId, extractionId, parameters);
        }
    }
}

