/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing.textclassification;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.auth.Authenticator;
import com.ibm.watsonx.ai.textprocessing.CosReference;
import com.ibm.watsonx.ai.textprocessing.CosUrl;
import com.ibm.watsonx.ai.textprocessing.DeleteFileRequest;
import com.ibm.watsonx.ai.textprocessing.Error;
import com.ibm.watsonx.ai.textprocessing.Status;
import com.ibm.watsonx.ai.textprocessing.UploadRequest;
import com.ibm.watsonx.ai.textprocessing.textclassification.Parameters;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationDeleteParameters;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationException;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationFetchParameters;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationParameters;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationRequest;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationResponse;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationRestClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextClassificationService
extends WatsonxService.ProjectService {
    private static final Logger logger = LoggerFactory.getLogger(TextClassificationService.class);
    private final String cosUrl;
    private final CosReference documentReference;
    private final TextClassificationRestClient client;

    private TextClassificationService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.authenticator(), "authenticator cannot be null");
        String tmpUrl = Objects.requireNonNull(builder.cosUrl, "cosUrl value cannot be null");
        this.cosUrl = tmpUrl.endsWith("/") ? tmpUrl.substring(0, tmpUrl.length() - 1) : tmpUrl;
        this.documentReference = Objects.requireNonNull(builder.documentReference, "documentReference value cannot be null");
        this.client = (TextClassificationRestClient)((TextClassificationRestClient.Builder)((TextClassificationRestClient.Builder)((TextClassificationRestClient.Builder)((TextClassificationRestClient.Builder)((TextClassificationRestClient.Builder)((TextClassificationRestClient.Builder)((TextClassificationRestClient.Builder)((TextClassificationRestClient.Builder)TextClassificationRestClient.builder().cosUrl(this.cosUrl).baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticator(builder.authenticator())).cosAuthenticator(builder.cosAuthenticator).httpClient(this.httpClient)).verifySsl(this.verifySsl)).build();
    }

    public TextClassificationResponse startClassification(String absolutePath) throws TextClassificationException {
        return this.startClassification(absolutePath, null);
    }

    public TextClassificationResponse startClassification(String absolutePath, TextClassificationParameters parameters) throws TextClassificationException {
        return this.startClassification(UUID.randomUUID().toString(), absolutePath, parameters, false);
    }

    public TextClassificationResponse uploadAndStartClassification(File file) throws TextClassificationException {
        return this.uploadAndStartClassification(file, null);
    }

    public TextClassificationResponse uploadAndStartClassification(File file, TextClassificationParameters parameters) throws TextClassificationException {
        Objects.requireNonNull(file);
        if (file.isDirectory()) {
            throw new TextClassificationException("directory_not_allowed", "The file can not be a directory");
        }
        String requestId = UUID.randomUUID().toString();
        try {
            this.upload(requestId, new BufferedInputStream(new FileInputStream(file)), file.getName(), parameters, false);
            return this.startClassification(requestId, file.getName(), parameters, false);
        }
        catch (FileNotFoundException e) {
            throw new TextClassificationException("file_not_found", e.getMessage(), e);
        }
    }

    public TextClassificationResponse uploadAndStartClassification(InputStream is, String fileName) throws TextClassificationException {
        return this.uploadAndStartClassification(is, fileName, null);
    }

    public TextClassificationResponse uploadAndStartClassification(InputStream is, String fileName, TextClassificationParameters parameters) throws TextClassificationException {
        String requestId = UUID.randomUUID().toString();
        this.upload(requestId, is, fileName, parameters, false);
        return this.startClassification(requestId, fileName, parameters, false);
    }

    public TextClassificationResponse.ClassificationResult classifyAndFetch(String absolutePath) throws TextClassificationException {
        return this.classifyAndFetch(absolutePath, null);
    }

    public TextClassificationResponse.ClassificationResult classifyAndFetch(String absolutePath, TextClassificationParameters parameters) throws TextClassificationException {
        return this.classifyAndFetch(UUID.randomUUID().toString(), absolutePath, parameters);
    }

    public TextClassificationResponse.ClassificationResult uploadClassifyAndFetch(File file) throws TextClassificationException {
        return this.uploadClassifyAndFetch(file, null);
    }

    public TextClassificationResponse.ClassificationResult uploadClassifyAndFetch(File file, TextClassificationParameters parameters) throws TextClassificationException {
        String requestId = UUID.randomUUID().toString();
        try {
            this.upload(requestId, new BufferedInputStream(new FileInputStream(file)), file.getName(), parameters, true);
        }
        catch (FileNotFoundException e) {
            throw new TextClassificationException("file_not_found", e.getMessage(), e);
        }
        return this.classifyAndFetch(requestId, file.getName(), parameters);
    }

    public TextClassificationResponse.ClassificationResult uploadClassifyAndFetch(InputStream is, String fileName) throws TextClassificationException {
        return this.uploadClassifyAndFetch(is, fileName, null);
    }

    public TextClassificationResponse.ClassificationResult uploadClassifyAndFetch(InputStream is, String fileName, TextClassificationParameters parameters) throws TextClassificationException {
        String requestId = UUID.randomUUID().toString();
        this.upload(requestId, is, fileName, parameters, true);
        return this.classifyAndFetch(requestId, fileName, parameters);
    }

    public TextClassificationResponse fetchClassificationRequest(String id) {
        return this.fetchClassificationRequest(id, TextClassificationFetchParameters.builder().build());
    }

    public TextClassificationResponse fetchClassificationRequest(String id, TextClassificationFetchParameters parameters) {
        return this.fetchClassificationRequest(UUID.randomUUID().toString(), id, parameters);
    }

    public boolean uploadFile(File file) throws TextClassificationException {
        try {
            return this.uploadFile(new BufferedInputStream(new FileInputStream(file)), file.getName());
        }
        catch (FileNotFoundException e) {
            throw new TextClassificationException("file_not_found", e.getMessage(), e);
        }
    }

    public boolean uploadFile(InputStream inputStream, String fileName) {
        String requestId = UUID.randomUUID().toString();
        this.upload(requestId, inputStream, fileName, null, false);
        return true;
    }

    public boolean deleteFile(String bucketName, String fileName) {
        return this.client.deleteFile(DeleteFileRequest.of(bucketName, fileName));
    }

    public boolean deleteRequest(String id) {
        return this.deleteRequest(id, TextClassificationDeleteParameters.builder().build());
    }

    public boolean deleteRequest(String id, TextClassificationDeleteParameters parameters) {
        Objects.requireNonNull(id, "The id can not be null");
        TextClassificationDeleteParameters.Builder builder = TextClassificationDeleteParameters.builder();
        Optional.ofNullable(parameters.projectId()).ifPresent(builder::projectId);
        Optional.ofNullable(parameters.spaceId()).ifPresent(builder::spaceId);
        if (Objects.isNull(parameters.projectId()) && Objects.isNull(parameters.spaceId())) {
            ((TextClassificationDeleteParameters.Builder)builder.projectId(this.projectId)).spaceId(this.spaceId);
        }
        TextClassificationDeleteParameters p = ((TextClassificationDeleteParameters.Builder)builder.transactionId(parameters.transactionId())).hardDelete(parameters.hardDelete().orElse(null)).build();
        TextClassificationRestClient.DeleteClassificationRequest request = TextClassificationRestClient.DeleteClassificationRequest.of(parameters.transactionId(), id, p);
        return this.client.deleteClassification(request);
    }

    private TextClassificationResponse fetchClassificationRequest(String requestId, String id, TextClassificationFetchParameters parameters) {
        Objects.requireNonNull(requestId, "The requestId can not be null");
        Objects.requireNonNull(id, "The id can not be null");
        TextClassificationFetchParameters.Builder builder = TextClassificationFetchParameters.builder();
        Optional.ofNullable(parameters.projectId()).ifPresent(builder::projectId);
        Optional.ofNullable(parameters.spaceId()).ifPresent(builder::spaceId);
        if (Objects.isNull(parameters.projectId()) && Objects.isNull(parameters.spaceId())) {
            ((TextClassificationFetchParameters.Builder)builder.projectId(this.projectId)).spaceId(this.spaceId);
        }
        TextClassificationFetchParameters p = ((TextClassificationFetchParameters.Builder)builder.transactionId(parameters.transactionId())).build();
        TextClassificationRestClient.FetchClassificationDetailsRequest request = TextClassificationRestClient.FetchClassificationDetailsRequest.of(requestId, id, p);
        return this.client.fetchClassificationDetails(request);
    }

    private TextClassificationResponse.ClassificationResult classifyAndFetch(String requestId, String absolutePath, TextClassificationParameters parameters) throws TextClassificationException {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        TextClassificationResponse textClassificationResponse = this.startClassification(requestId, absolutePath, parameters, true);
        return this.getClassificationResult(requestId, textClassificationResponse, parameters);
    }

    private void upload(String requestId, InputStream is, String fileName, TextClassificationParameters parameters, boolean waitForClassification) {
        Objects.requireNonNull(requestId, "requestId value cannot be null");
        Objects.requireNonNull(is, "is value cannot be null");
        Objects.requireNonNull(fileName, "fileName value cannot be null");
        boolean removeOutputFile = false;
        CosReference documentReference = this.documentReference;
        if (Objects.nonNull(parameters)) {
            documentReference = Objects.requireNonNullElse(parameters.documentReference(), this.documentReference);
        }
        if (!waitForClassification && removeOutputFile) {
            throw new IllegalArgumentException("The asynchronous version of startClassification doesn't allow the use of the \"removeUploadedFile\" parameter");
        }
        UploadRequest request = UploadRequest.of(requestId, documentReference.bucket(), is, fileName);
        this.client.upload(request);
    }

    private TextClassificationResponse startClassification(String requestId, String path, TextClassificationParameters parameters, boolean waitUntilJobIsDone) throws TextClassificationException {
        Status status;
        Objects.requireNonNull(path);
        Objects.requireNonNull(requestId);
        String projectId = null;
        String spaceId = null;
        boolean removeUploadedFile = false;
        CosReference documentReference = this.documentReference;
        Parameters params = null;
        Map<String, Object> custom = null;
        Duration timeout = Duration.ofSeconds(60L);
        String transactionId = null;
        if (Objects.nonNull(parameters)) {
            removeUploadedFile = parameters.isRemoveUploadedFile();
            projectId = parameters.projectId();
            spaceId = parameters.spaceId();
            documentReference = Objects.requireNonNullElse(parameters.documentReference(), this.documentReference);
            params = parameters.toParameters();
            custom = parameters.custom();
            timeout = Objects.requireNonNullElse(parameters.timeout(), Duration.ofSeconds(60L));
            transactionId = parameters.transactionId();
        }
        if (Objects.isNull(projectId) && Objects.isNull(spaceId)) {
            projectId = this.projectId;
            spaceId = this.spaceId;
        }
        if (!waitUntilJobIsDone && removeUploadedFile) {
            throw new IllegalArgumentException("The asynchronous version of startClassification doesn't allow the use of the \"removeUploadedFile\" parameter");
        }
        TextClassificationRequest textClassificationRequest = new TextClassificationRequest(projectId, spaceId, documentReference.toDataReference(path), params, custom);
        TextClassificationRestClient.StartClassificationRequest request = TextClassificationRestClient.StartClassificationRequest.of(requestId, transactionId, textClassificationRequest);
        TextClassificationResponse response = this.client.startClassification(request);
        if (!waitUntilJobIsDone) {
            return response;
        }
        long sleepTime = 100L;
        LocalTime endTime = LocalTime.now().plus(timeout);
        do {
            if (LocalTime.now().isAfter(endTime)) {
                throw new TextClassificationException("timeout", "The execution of the classification %s file took longer than the timeout set by %s milliseconds".formatted(path, timeout.toMillis()));
            }
            try {
                Thread.sleep(sleepTime);
                sleepTime *= 2L;
                sleepTime = Math.min(sleepTime, 3000L);
            }
            catch (Exception e) {
                throw new TextClassificationException("interrupted", e.getMessage());
            }
            String processId = response.metadata().id();
            response = this.fetchClassificationRequest(requestId, processId, ((TextClassificationFetchParameters.Builder)((TextClassificationFetchParameters.Builder)TextClassificationFetchParameters.builder().projectId(projectId)).spaceId(spaceId)).build());
            status = Status.fromValue(response.entity().results().status());
            logger.debug("Classification status: {} for the file {}", (Object)status, (Object)path);
        } while (status != Status.FAILED && status != Status.COMPLETED);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextClassificationResponse.ClassificationResult getClassificationResult(String requestId, TextClassificationResponse textClassificationResponse, TextClassificationParameters parameters) throws TextClassificationException {
        Objects.requireNonNull(requestId);
        String uploadedPath = textClassificationResponse.entity().documentReference().location().fileName();
        Status status = Status.fromValue(textClassificationResponse.entity().results().status());
        boolean removeUploadedFile = false;
        CosReference documentReference = this.documentReference;
        if (Objects.nonNull(parameters)) {
            removeUploadedFile = parameters.isRemoveUploadedFile();
            documentReference = Objects.requireNonNullElse(parameters.documentReference(), this.documentReference);
        }
        String documentBucketName = documentReference.bucket();
        try {
            switch (status) {
                case COMPLETED: {
                    break;
                }
                default: {
                    Error error = textClassificationResponse.entity().results().error();
                    throw new TextClassificationException(error.code(), error.message());
                }
            }
            TextClassificationResponse.ClassificationResult classificationResult = textClassificationResponse.entity().results();
            return classificationResult;
        }
        finally {
            if (removeUploadedFile) {
                try {
                    String encodedFileName = new URI(null, null, uploadedPath, null).toASCIIString();
                    DeleteFileRequest request = DeleteFileRequest.of(requestId, documentBucketName, encodedFileName);
                    this.client.asyncDeleteFile(request);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxService.ProjectService.Builder<Builder> {
        private String cosUrl;
        private Authenticator cosAuthenticator;
        private CosReference documentReference;

        private Builder() {
        }

        public Builder cosUrl(String cosUrl) {
            this.cosUrl = cosUrl;
            return this;
        }

        public Builder cosAuthenticator(Authenticator cosAuthenticator) {
            this.cosAuthenticator = cosAuthenticator;
            return this;
        }

        public Builder cosUrl(CosUrl cosUrl) {
            Objects.requireNonNull(cosUrl, "cosUrl cannot be null");
            return this.cosUrl(cosUrl.value());
        }

        public Builder documentReference(CosReference documentReference) {
            this.documentReference = documentReference;
            return this;
        }

        public Builder documentReference(String connectionId, String bucket) {
            return this.documentReference(CosReference.of(connectionId, bucket));
        }

        public TextClassificationService build() {
            return new TextClassificationService(this);
        }
    }
}

