/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing;

import com.ibm.watsonx.ai.textprocessing.Schema;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class SemanticConfig {
    private final Boolean enableTextHints;
    private final Boolean enableGenericKvp;
    private final Boolean enableSchemaKvp;
    private final String groundingMode;
    private final String schemasMergeStrategy;
    private final String forceSchemaName;
    private final List<Schema> schemas;
    private final String defaultModelName;
    private final Map<String, Object> taskModelNameOverride;

    protected SemanticConfig(Builder<?> builder) {
        this.enableTextHints = builder.enableTextHints;
        this.enableGenericKvp = builder.enableGenericKvp;
        this.enableSchemaKvp = builder.enableSchemaKvp;
        this.groundingMode = builder.groundingMode;
        this.schemasMergeStrategy = Objects.nonNull((Object)builder.schemasMergeStrategy) ? builder.schemasMergeStrategy.value() : null;
        this.forceSchemaName = builder.forceSchemaName;
        this.schemas = builder.schemas;
        this.defaultModelName = builder.defaultModelName;
        this.taskModelNameOverride = builder.taskModelNameOverride;
    }

    public Boolean enableTextHints() {
        return this.enableTextHints;
    }

    public Boolean enableGenericKvp() {
        return this.enableGenericKvp;
    }

    public Boolean enableSchemaKvp() {
        return this.enableSchemaKvp;
    }

    public String groundingMode() {
        return this.groundingMode;
    }

    public String forceSchemaName() {
        return this.forceSchemaName;
    }

    public String defaultModelName() {
        return this.defaultModelName;
    }

    public Map<String, Object> taskModelNameOverride() {
        return this.taskModelNameOverride;
    }

    public String schemasMergeStrategy() {
        return this.schemasMergeStrategy;
    }

    public List<Schema> schemas() {
        return this.schemas;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private Boolean enableTextHints;
        private Boolean enableGenericKvp;
        private Boolean enableSchemaKvp;
        private String groundingMode;
        private SchemaMergeStrategy schemasMergeStrategy;
        private String forceSchemaName;
        private List<Schema> schemas;
        private String defaultModelName;
        private Map<String, Object> taskModelNameOverride;

        public T enableTextHints(Boolean enableTextHints) {
            this.enableTextHints = enableTextHints;
            return (T)this;
        }

        public T enableGenericKvp(Boolean enableGenericKvp) {
            this.enableGenericKvp = enableGenericKvp;
            return (T)this;
        }

        public T enableSchemaKvp(Boolean enableSchemaKvp) {
            this.enableSchemaKvp = enableSchemaKvp;
            return (T)this;
        }

        public T groundingMode(String groundingMode) {
            this.groundingMode = groundingMode;
            return (T)this;
        }

        public T forceSchemaName(String forceSchemaName) {
            this.forceSchemaName = forceSchemaName;
            return (T)this;
        }

        public T defaultModelName(String defaultModelName) {
            this.defaultModelName = defaultModelName;
            return (T)this;
        }

        public T taskModelNameOverride(Map<String, Object> taskModelNameOverride) {
            this.taskModelNameOverride = taskModelNameOverride;
            return (T)this;
        }

        public T schemasMergeStrategy(SchemaMergeStrategy schemasMergeStrategy) {
            this.schemasMergeStrategy = schemasMergeStrategy;
            return (T)this;
        }

        public T schemas(Schema ... schemas) {
            return this.schemas(List.of(schemas));
        }

        public T schemas(List<Schema> schemas) {
            this.schemas = schemas;
            return (T)this;
        }
    }

    public static enum SchemaMergeStrategy {
        MERGE("merge"),
        REPLACE("replace");

        private String value;

        private SchemaMergeStrategy(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

