/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing;

import com.ibm.watsonx.ai.textprocessing.KvpFields;
import com.ibm.watsonx.ai.textprocessing.KvpPage;
import java.util.Map;
import java.util.Objects;

public final class Schema {
    private final String documentType;
    private final String documentDescription;
    private final Map<String, KvpFields.KvpField> fields;
    private final KvpPage pages;
    private final String additionalPromptInstructions;

    private Schema(Builder builder) {
        this.documentType = builder.documentType;
        this.documentDescription = builder.documentDescription;
        this.fields = Objects.nonNull(builder.fields) ? builder.fields.fields() : null;
        this.pages = builder.pages;
        this.additionalPromptInstructions = builder.additionalPromptInstructions;
    }

    public String documentType() {
        return this.documentType;
    }

    public String documentDescription() {
        return this.documentDescription;
    }

    public Map<String, KvpFields.KvpField> fields() {
        return this.fields;
    }

    public KvpPage pages() {
        return this.pages;
    }

    public String additionalPromptInstructions() {
        return this.additionalPromptInstructions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.documentType == null ? 0 : this.documentType.hashCode());
        result = 31 * result + (this.documentDescription == null ? 0 : this.documentDescription.hashCode());
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.pages == null ? 0 : this.pages.hashCode());
        result = 31 * result + (this.additionalPromptInstructions == null ? 0 : this.additionalPromptInstructions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schema other = (Schema)obj;
        if (this.documentType == null ? other.documentType != null : !this.documentType.equals(other.documentType)) {
            return false;
        }
        if (this.documentDescription == null ? other.documentDescription != null : !this.documentDescription.equals(other.documentDescription)) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        if (this.pages == null ? other.pages != null : !this.pages.equals(other.pages)) {
            return false;
        }
        return !(this.additionalPromptInstructions == null ? other.additionalPromptInstructions != null : !this.additionalPromptInstructions.equals(other.additionalPromptInstructions));
    }

    public String toString() {
        return "Schema [documentType=" + this.documentType + ", documentDescription=" + this.documentDescription + ", fields=" + String.valueOf(this.fields) + ", pages=" + String.valueOf(this.pages) + ", additionalPromptInstructions=" + this.additionalPromptInstructions + "]";
    }

    public static final class Builder {
        private String documentType;
        private String documentDescription;
        private KvpFields fields;
        private KvpPage pages;
        private String additionalPromptInstructions;

        public Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        public Builder documentDescription(String documentDescription) {
            this.documentDescription = documentDescription;
            return this;
        }

        public Builder fields(KvpFields fields) {
            this.fields = fields;
            return this;
        }

        public Builder pages(KvpPage pages) {
            this.pages = pages;
            return this;
        }

        public Builder additionalPromptInstructions(String additionalPromptInstructions) {
            this.additionalPromptInstructions = additionalPromptInstructions;
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

