/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class KvpFields {
    private final Map<String, KvpField> fieldMap;

    private KvpFields(Builder builder) {
        this.fieldMap = builder.fields;
    }

    public Map<String, KvpField> fields() {
        return this.fieldMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldMap == null ? 0 : this.fieldMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KvpFields other = (KvpFields)obj;
        return !(this.fieldMap == null ? other.fieldMap != null : !this.fieldMap.equals(other.fieldMap));
    }

    public String toString() {
        return "KvpFields [fieldMap=" + String.valueOf(this.fieldMap) + "]";
    }

    public static final class Builder {
        private Map<String, KvpField> fields;

        private Builder() {
        }

        public Builder add(String name, KvpField field) {
            Objects.requireNonNull(name, "name can not be null");
            Objects.requireNonNull(field, "field can not be null");
            this.fields = Objects.requireNonNullElse(this.fields, new HashMap());
            this.fields.put(name, field);
            return this;
        }

        public KvpFields build() {
            return new KvpFields(this);
        }
    }

    public record KvpField(String description, String example, List<String> availableOptions) {
        public KvpField {
            Objects.requireNonNull(description, "description can not be null");
            Objects.requireNonNull(example, "example can not be null");
        }

        public static KvpField of(String description, String example) {
            return KvpField.of(description, example, null);
        }

        public static KvpField of(String description, String example, List<String> availableOptions) {
            return new KvpField(description, example, availableOptions);
        }
    }
}

