/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.rerank;

import com.ibm.watsonx.ai.Crypto;
import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.rerank.RerankParameters;
import com.ibm.watsonx.ai.rerank.RerankRequest;
import com.ibm.watsonx.ai.rerank.RerankResponse;
import com.ibm.watsonx.ai.rerank.RerankRestClient;
import java.util.List;
import java.util.Objects;

public class RerankService
extends WatsonxService.ModelService {
    private final RerankRestClient client;

    private RerankService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.authenticator(), "authenticator cannot be null");
        this.client = (RerankRestClient)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)RerankRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticator(builder.authenticator())).httpClient(this.httpClient)).verifySsl(this.verifySsl)).build();
    }

    public RerankResponse rerank(String query, List<String> inputs) {
        return this.rerank(query, inputs, null);
    }

    public RerankResponse rerank(String query, List<String> inputs, RerankParameters parameters) {
        Objects.requireNonNull(query, "Query cannot be null");
        Objects.requireNonNull(inputs, "Inputs cannot be null");
        WatsonxService.ProjectService.ProjectSpace projectSpace = this.resolveProjectSpace(parameters);
        String projectId = projectSpace.projectId();
        String spaceId = projectSpace.spaceId();
        String modelId = this.modelId;
        String transactionId = null;
        Crypto crypto = null;
        RerankRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.modelId(), this.modelId);
            transactionId = parameters.transactionId();
            requestParameters = parameters.toRerankRequestParameters();
            crypto = Objects.nonNull(parameters.crypto()) ? new Crypto(parameters.crypto()) : null;
        }
        RerankRequest rerankRequest = new RerankRequest(modelId, inputs.stream().map(RerankRequest.RerankInput::new).toList(), query, spaceId, projectId, requestParameters, crypto);
        return this.client.rerank(transactionId, rerankRequest);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public RerankService build() {
            return new RerankService(this);
        }
    }
}

