/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.deployment;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.chat.ChatClientContext;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatProvider;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.interceptor.InterceptorContext;
import com.ibm.watsonx.ai.chat.interceptor.MessageInterceptor;
import com.ibm.watsonx.ai.chat.interceptor.ToolInterceptor;
import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.chat.model.Thinking;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.core.Utils;
import com.ibm.watsonx.ai.deployment.DeploymentResource;
import com.ibm.watsonx.ai.deployment.DeploymentRestClient;
import com.ibm.watsonx.ai.deployment.FindByIdRequest;
import com.ibm.watsonx.ai.textgeneration.Moderation;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationParameters;
import com.ibm.watsonx.ai.textgeneration.TextGenerationProvider;
import com.ibm.watsonx.ai.textgeneration.TextGenerationRequest;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import com.ibm.watsonx.ai.textgeneration.TextRequest;
import com.ibm.watsonx.ai.timeseries.ForecastData;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import com.ibm.watsonx.ai.timeseries.InputSchema;
import com.ibm.watsonx.ai.timeseries.TimeSeriesParameters;
import com.ibm.watsonx.ai.timeseries.TimeSeriesProvider;
import com.ibm.watsonx.ai.timeseries.TimeSeriesRequest;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentService
extends WatsonxService
implements ChatProvider,
TextGenerationProvider,
TimeSeriesProvider {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);
    private final DeploymentRestClient client;
    private final MessageInterceptor messageInterceptor;
    private final ToolInterceptor toolInterceptor;
    private final ChatProvider chatProvider;
    private final ChatParameters defaultParameters;
    private final List<Tool> defaultTools;

    private DeploymentService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.authenticator(), "authenticator cannot be null");
        this.messageInterceptor = builder.messageInterceptor;
        this.toolInterceptor = builder.toolInterceptor;
        this.defaultTools = builder.defaultTools;
        this.defaultParameters = Objects.requireNonNullElse(builder.defaultParameters, ChatParameters.builder().build());
        this.client = (DeploymentRestClient)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)DeploymentRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticator(builder.authenticator())).httpClient(this.httpClient)).verifySsl(this.verifySsl)).build();
        this.chatProvider = Objects.nonNull(this.messageInterceptor) || Objects.nonNull(this.toolInterceptor) ? ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().authenticator(builder.authenticator())).baseUrl(this.baseUrl)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).version(this.version)).parameters(this.defaultParameters).httpClient(this.httpClient)).verifySsl(this.verifySsl)).build() : null;
    }

    public DeploymentResource findById(FindByIdRequest parameters) {
        Objects.requireNonNull(parameters, "FindByIdRequest cannot be null");
        Objects.requireNonNull(parameters.deploymentId(), "deploymentId must be provided");
        if (Objects.isNull(parameters.projectId()) && Objects.isNull(parameters.spaceId())) {
            throw new IllegalArgumentException("Either projectId or spaceId must be provided");
        }
        return this.client.findById(parameters);
    }

    @Override
    public TextGenerationResponse generate(TextGenerationRequest textGenerationRequest) {
        Objects.requireNonNull(textGenerationRequest, "textGenerationRequest cannot be null");
        String input = textGenerationRequest.input();
        Moderation moderation = textGenerationRequest.moderation();
        String deploymentId = Objects.requireNonNull(textGenerationRequest.deploymentId(), "deploymentId must be provided");
        TextGenerationParameters parameters = Objects.requireNonNullElse(textGenerationRequest.parameters(), TextGenerationParameters.builder().build());
        Duration timeout = Duration.ofMillis(Objects.requireNonNullElse(parameters.timeLimit(), this.timeout.toMillis()));
        this.logIgnoredParameters(parameters.modelId(), parameters.projectId(), parameters.spaceId());
        TextRequest textRequest = new TextRequest(null, null, null, input, parameters.toSanitized(), moderation);
        return this.client.generate(parameters.transactionId(), deploymentId, timeout, textRequest);
    }

    @Override
    public CompletableFuture<Void> generateStreaming(TextGenerationRequest textGenerationRequest, TextGenerationHandler handler) {
        Objects.requireNonNull(textGenerationRequest, "textGenerationRequest cannot be null");
        String input = textGenerationRequest.input();
        String deploymentId = Objects.requireNonNull(textGenerationRequest.deploymentId(), "deploymentId must be provided");
        TextGenerationParameters parameters = Objects.requireNonNullElse(textGenerationRequest.parameters(), TextGenerationParameters.builder().build());
        Duration timeout = Duration.ofMillis(Objects.requireNonNullElse(parameters.timeLimit(), this.timeout.toMillis()));
        this.logIgnoredParameters(parameters.modelId(), parameters.projectId(), parameters.spaceId());
        TextRequest textGenRequest = new TextRequest(null, null, null, input, parameters.toSanitized(), null);
        return this.client.generateStreaming(parameters.transactionId(), deploymentId, timeout, textGenRequest, handler);
    }

    @Override
    public ChatResponse chat(ChatRequest chatRequest) {
        List<ChatResponse.ResultChoice> newChoices;
        Objects.requireNonNull(chatRequest, "chatRequest cannot be null");
        String deploymentId = Objects.requireNonNull(chatRequest.deploymentId(), "deploymentId must be provided");
        TextChatRequest textChatRequest = this.buildTextChatRequest(chatRequest);
        String transactionId = Objects.nonNull(chatRequest.parameters()) ? chatRequest.parameters().transactionId() : null;
        long timeout = Objects.nonNull(chatRequest.parameters()) && Objects.nonNull(chatRequest.parameters().timeLimit()) ? chatRequest.parameters().timeLimit().longValue() : this.timeout.toMillis();
        ChatResponse chatResponse = this.client.chat(transactionId, deploymentId, Duration.ofMillis(timeout), textChatRequest);
        if (Objects.nonNull(this.messageInterceptor)) {
            newChoices = this.messageInterceptor.intercept(new InterceptorContext(this.chatProvider, chatRequest, chatResponse));
            chatResponse = chatResponse.toBuilder().choices(newChoices).build();
        }
        if (Objects.nonNull(this.toolInterceptor)) {
            newChoices = this.toolInterceptor.intercept(new InterceptorContext(this.chatProvider, chatRequest, chatResponse));
            chatResponse = chatResponse.toBuilder().choices(newChoices).build();
        }
        return chatResponse;
    }

    @Override
    public CompletableFuture<ChatResponse> chatStreaming(ChatRequest chatRequest, ChatHandler handler) {
        Objects.requireNonNull(chatRequest, "chatRequest cannot be null");
        Objects.requireNonNull(handler, "The chatHandler parameter can not be null");
        String deploymentId = Objects.requireNonNull(chatRequest.deploymentId(), "deploymentId must be provided");
        TextChatRequest textChatRequest = this.buildTextChatRequest(chatRequest);
        ExtractionTags extractionTags = Objects.nonNull(chatRequest.thinking()) ? chatRequest.thinking().extractionTags() : null;
        String transactionId = Objects.nonNull(chatRequest.parameters()) ? chatRequest.parameters().transactionId() : null;
        ChatClientContext context = ChatClientContext.builder().chatProvider(this.chatProvider).chatRequest(chatRequest).toolInterceptor(this.toolInterceptor).extractionTags(extractionTags).build();
        return this.client.chatStreaming(transactionId, deploymentId, textChatRequest, context, handler);
    }

    @Override
    public ForecastResponse forecast(TimeSeriesRequest timeSeriesRequest) {
        Objects.requireNonNull(timeSeriesRequest, "timeSeriesRequest cannot be null");
        String deploymentId = Objects.requireNonNull(timeSeriesRequest.deploymentId(), "deploymentId must be provided");
        InputSchema inputSchema = timeSeriesRequest.inputSchema();
        ForecastData data = timeSeriesRequest.data();
        TimeSeriesParameters parameters = timeSeriesRequest.parameters();
        ForecastRequest.Parameters requestParameters = null;
        Map futureData = null;
        String transactionId = null;
        if (Objects.nonNull(parameters)) {
            this.logIgnoredParameters(parameters.modelId(), parameters.projectId(), parameters.spaceId());
            requestParameters = parameters.toParameters();
            futureData = Optional.ofNullable(parameters.futureData()).map(p -> p.asMap()).orElse(null);
            transactionId = parameters.transactionId();
        }
        ForecastRequest forecastRequest = new ForecastRequest(null, null, null, data.asMap(), inputSchema, futureData, requestParameters);
        return this.client.forecast(transactionId, deploymentId, this.timeout, forecastRequest);
    }

    public static Builder builder() {
        return new Builder();
    }

    private TextChatRequest buildTextChatRequest(ChatRequest chatRequest) {
        List<ChatMessage> messages = chatRequest.messages();
        List<Tool> tools = Objects.isNull(chatRequest.tools()) ? this.defaultTools : chatRequest.tools();
        tools = Objects.nonNull(tools) && !tools.isEmpty() ? tools : null;
        ChatParameters parameters = Objects.requireNonNullElse(chatRequest.parameters(), ChatParameters.builder().build());
        Duration timeout = Duration.ofMillis(Objects.requireNonNullElse(this.defaultParameters.timeLimit(), this.timeout.toMillis()));
        Boolean includeReasoning = null;
        String thinkingEffort = null;
        Map<String, Object> chatTemplateKwargs = null;
        if (Objects.nonNull(chatRequest.thinking())) {
            Thinking thinking = chatRequest.thinking();
            chatTemplateKwargs = Map.of("thinking", true);
            includeReasoning = thinking.includeReasoning();
            thinkingEffort = Objects.nonNull((Object)thinking.thinkingEffort()) ? thinking.thinkingEffort().getValue() : null;
        }
        this.logIgnoredParameters(parameters.modelId(), parameters.projectId(), parameters.spaceId());
        return TextChatRequest.builder().messages(messages).tools(tools).toolChoiceOption((String)Utils.getOrDefault((Object)parameters.toolChoiceOption(), (Object)this.defaultParameters.toolChoiceOption())).toolChoice((Map)Utils.getOrDefault(parameters.toolChoice(), this.defaultParameters.toolChoice())).frequencyPenalty((Double)Utils.getOrDefault((Object)parameters.frequencyPenalty(), (Object)this.defaultParameters.frequencyPenalty())).logitBias((Map)Utils.getOrDefault(parameters.logitBias(), this.defaultParameters.logitBias())).logprobs((Boolean)Utils.getOrDefault((Object)parameters.logprobs(), (Object)this.defaultParameters.logprobs())).topLogprobs((Integer)Utils.getOrDefault((Object)parameters.topLogprobs(), (Object)this.defaultParameters.topLogprobs())).maxCompletionTokens((Integer)Utils.getOrDefault((Object)parameters.maxCompletionTokens(), (Object)this.defaultParameters.maxCompletionTokens())).n((Integer)Utils.getOrDefault((Object)parameters.n(), (Object)this.defaultParameters.n())).presencePenalty((Double)Utils.getOrDefault((Object)parameters.presencePenalty(), (Object)this.defaultParameters.presencePenalty())).seed((Integer)Utils.getOrDefault((Object)parameters.seed(), (Object)this.defaultParameters.seed())).stop((List)Utils.getOrDefault(parameters.stop(), this.defaultParameters.stop())).temperature((Double)Utils.getOrDefault((Object)parameters.temperature(), (Object)this.defaultParameters.temperature())).topP((Double)Utils.getOrDefault((Object)parameters.topP(), (Object)this.defaultParameters.topP())).responseFormat((String)Utils.getOrDefault((Object)parameters.responseFormat(), (Object)this.defaultParameters.responseFormat())).jsonSchema((ChatParameters.JsonSchemaObject)Utils.getOrDefault((Object)parameters.jsonSchema(), (Object)this.defaultParameters.jsonSchema())).context((String)Utils.getOrDefault((Object)parameters.context(), (Object)this.defaultParameters.context())).timeLimit((Long)Utils.getOrDefault((Object)parameters.timeLimit(), (Object)timeout.toMillis())).guidedChoice((Set)Utils.getOrDefault(parameters.guidedChoice(), this.defaultParameters.guidedChoice())).guidedRegex((String)Utils.getOrDefault((Object)parameters.guidedRegex(), (Object)this.defaultParameters.guidedRegex())).guidedGrammar((String)Utils.getOrDefault((Object)parameters.guidedGrammar(), (Object)this.defaultParameters.guidedGrammar())).repetitionPenalty((Double)Utils.getOrDefault((Object)parameters.repetitionPenalty(), (Object)this.defaultParameters.repetitionPenalty())).lengthPenalty((Double)Utils.getOrDefault((Object)parameters.lengthPenalty(), (Object)this.defaultParameters.lengthPenalty())).includeReasoning(includeReasoning).reasoningEffort(thinkingEffort).chatTemplateKwargs(chatTemplateKwargs).build();
    }

    private void logIgnoredParameters(String modelId, String projectId, String spaceId) {
        if (Objects.nonNull(modelId)) {
            logger.info("The modelId parameter is ignored for the DeploymentService");
        }
        if (Objects.nonNull(projectId)) {
            logger.info("The projectId parameter is ignored for the DeploymentService");
        }
        if (Objects.nonNull(spaceId)) {
            logger.info("The spaceId parameter is ignored for the DeploymentService");
        }
    }

    public static final class Builder
    extends WatsonxService.Builder<Builder> {
        private MessageInterceptor messageInterceptor;
        private ToolInterceptor toolInterceptor;
        private ChatParameters defaultParameters;
        private List<Tool> defaultTools;

        private Builder() {
        }

        public Builder parameters(ChatParameters parameters) {
            this.defaultParameters = parameters;
            return this;
        }

        public Builder messageInterceptor(MessageInterceptor messageInterceptor) {
            this.messageInterceptor = messageInterceptor;
            return this;
        }

        public Builder toolInterceptor(ToolInterceptor toolInterceptor) {
            this.toolInterceptor = toolInterceptor;
            return this;
        }

        public Builder tools(ExecutableTool ... executableTools) {
            return this.tools(Arrays.stream(executableTools).map(ExecutableTool::schema).toList());
        }

        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        public Builder tools(List<Tool> tools) {
            this.defaultTools = tools;
            return this;
        }

        public DeploymentService build() {
            return new DeploymentService(this);
        }
    }
}

