/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.streaming;

import com.ibm.watsonx.ai.chat.model.CompletedToolCall;
import com.ibm.watsonx.ai.chat.model.ToolCall;
import java.util.Objects;
import java.util.UUID;

public final class StreamingToolFetcher {
    private volatile String completionId;
    private volatile int choiceIndex;
    private volatile int toolIndex;
    private StringBuffer arguments;
    private volatile String id;
    private volatile String name;

    public StreamingToolFetcher(String completionId, int choiceIndex, int toolIndex) {
        this.completionId = completionId;
        this.choiceIndex = choiceIndex;
        this.toolIndex = toolIndex;
        this.arguments = new StringBuffer();
    }

    public void setId(String id) {
        if (Objects.nonNull(id) && !id.isBlank()) {
            this.id = id;
        }
    }

    public void setName(String name) {
        if (Objects.nonNull(name) && !name.isBlank()) {
            this.name = name;
        }
    }

    public void appendArguments(String arguments) {
        if (Objects.nonNull(arguments) && !arguments.isEmpty()) {
            this.arguments.append(arguments);
        }
    }

    public void setArguments(String arguments) {
        this.arguments = new StringBuffer(arguments);
    }

    public int getToolIndex() {
        return this.toolIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public int getChoiceIndex() {
        return this.choiceIndex;
    }

    public CompletedToolCall build() {
        if (Objects.isNull(this.id)) {
            this.id = UUID.randomUUID().toString();
        }
        return new CompletedToolCall(this.completionId, this.choiceIndex, ToolCall.of(this.toolIndex, this.id, this.name, this.arguments.toString().isBlank() ? "{}" : this.arguments.toString()));
    }
}

