/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.streaming;

import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.SseEventProcessor;
import com.ibm.watsonx.ai.chat.decorator.ChatHandlerDecorator;
import com.ibm.watsonx.ai.chat.model.CompletedToolCall;
import com.ibm.watsonx.ai.chat.model.ToolCall;
import com.ibm.watsonx.ai.chat.streaming.ChatSubscriber;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DefaultChatSubscriber
implements ChatSubscriber {
    private final SseEventProcessor processor;
    private final ChatHandlerDecorator handler;

    public DefaultChatSubscriber(SseEventProcessor processor, ChatHandlerDecorator handler) {
        this.processor = processor;
        this.handler = handler;
    }

    @Override
    public void onNext(String partialMessage) {
        SseEventProcessor.ProcessResult result = this.processor.processChunk(partialMessage);
        if (result.hasError()) {
            Throwable error = result.error();
            if (error instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)error;
                throw re;
            }
            throw new RuntimeException(error);
        }
        for (SseEventProcessor.CallbackEvent event : result.events()) {
            if (event instanceof SseEventProcessor.CallbackEvent.PartialResponseEvent) {
                SseEventProcessor.CallbackEvent.PartialResponseEvent e = (SseEventProcessor.CallbackEvent.PartialResponseEvent)event;
                this.handler.onPartialResponse(e.content(), e.chunk());
                continue;
            }
            if (event instanceof SseEventProcessor.CallbackEvent.PartialThinkingEvent) {
                SseEventProcessor.CallbackEvent.PartialThinkingEvent e = (SseEventProcessor.CallbackEvent.PartialThinkingEvent)event;
                this.handler.onPartialThinking(e.content(), e.chunk());
                continue;
            }
            if (event instanceof SseEventProcessor.CallbackEvent.PartialToolCallEvent) {
                SseEventProcessor.CallbackEvent.PartialToolCallEvent e = (SseEventProcessor.CallbackEvent.PartialToolCallEvent)event;
                this.handler.onPartialToolCall(e.toolCall());
                continue;
            }
            if (event instanceof SseEventProcessor.CallbackEvent.CompleteToolCallEvent) {
                SseEventProcessor.CallbackEvent.CompleteToolCallEvent e = (SseEventProcessor.CallbackEvent.CompleteToolCallEvent)event;
                this.handler.onCompleteToolCall(e.completeToolCall());
                continue;
            }
            if (!(event instanceof SseEventProcessor.CallbackEvent.ErrorEvent)) continue;
            SseEventProcessor.CallbackEvent.ErrorEvent e = (SseEventProcessor.CallbackEvent.ErrorEvent)event;
            this.handler.onError(e.error());
        }
    }

    @Override
    public CompletableFuture<ChatResponse> onComplete() {
        return this.handler.awaitCallbacks().thenCompose(completeToolCalls -> {
            ChatResponse response = this.processor.buildResponse();
            if (Objects.nonNull(completeToolCalls) && !completeToolCalls.isEmpty()) {
                List<ChatResponse.ResultChoice> choices = response.choices().stream().map(choice -> {
                    List<ToolCall> tools = completeToolCalls.stream().filter(ctc -> ctc.index().equals(choice.index())).map(CompletedToolCall::toolCall).toList();
                    return choice.withResultMessage(choice.message().withToolCalls(tools));
                }).toList();
                this.handler.onCompleteResponse(response.toBuilder().choices(choices).build());
            } else {
                this.handler.onCompleteResponse(response);
            }
            return this.handler.awaitCallbacks().thenApply(ignored -> response);
        });
    }

    @Override
    public CompletableFuture<Void> onError(Throwable throwable) {
        this.handler.onError(throwable);
        return this.handler.awaitCallbacks().thenApply(v -> null);
    }
}

