/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.streaming;

import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.Tool;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public interface ChatSubscriber {
    public void onNext(String var1);

    public CompletableFuture<Void> onError(Throwable var1);

    public CompletableFuture<ChatResponse> onComplete();

    public static Map<String, Boolean> toolHasParameters(List<Tool> tools) {
        if (Objects.isNull(tools) || tools.size() == 0) {
            return Map.of();
        }
        return tools.stream().collect(Collectors.toMap(tool -> tool.function().name(), Tool::hasParameters));
    }

    public static Throwable handleError(Throwable t, ChatHandler handler) {
        t = Objects.nonNull(t.getCause()) ? t.getCause() : t;
        handler.onError(t);
        return t;
    }
}

