/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model.schema;

import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import com.ibm.watsonx.ai.chat.model.schema.RequiredSchema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ObjectSchema
extends JsonSchema {
    private final Map<String, JsonSchema> properties;
    private final Map<String, JsonSchema> patternProperties;
    private final List<String> required;
    private final List<RequiredSchema> anyOf;
    private final Integer minProperties;
    private final Integer maxProperties;
    private final Object additionalProperties;

    private ObjectSchema(Builder builder) {
        super(builder.nullable ? List.of("object", "null") : "object", builder);
        this.properties = builder.properties.isEmpty() ? null : builder.properties;
        this.required = builder.required;
        this.anyOf = builder.anyOf;
        this.minProperties = builder.minProperties;
        this.maxProperties = builder.maxProperties;
        this.patternProperties = builder.patternProperties;
        this.additionalProperties = builder.additionalProperties;
    }

    public Map<String, JsonSchema> properties() {
        return this.properties;
    }

    public List<String> required() {
        return this.required;
    }

    public List<RequiredSchema> anyOf() {
        return this.anyOf;
    }

    public Integer minProperties() {
        return this.minProperties;
    }

    public Integer maxProperties() {
        return this.maxProperties;
    }

    public Object additionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, JsonSchema> patternProperties() {
        return this.patternProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends JsonSchema.Builder<Builder, ObjectSchema, RequiredSchema.Builder> {
        private Map<String, JsonSchema> properties = new LinkedHashMap<String, JsonSchema>();
        private Map<String, JsonSchema> patternProperties;
        private Integer minProperties;
        private Integer maxProperties;
        private Object additionalProperties;
        private List<String> required;
        private List<RequiredSchema> anyOf;

        private Builder() {
        }

        public Builder property(String name, JsonSchema.Builder<?, ?, ?> schema) {
            this.properties.put(name, (JsonSchema)schema.build());
            return this;
        }

        public Builder minProperties(int minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        public Builder maxProperties(int maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder patternProperty(String name, JsonSchema.Builder<?, ?, ?> schema) {
            this.patternProperties = Objects.requireNonNullElse(this.patternProperties, new LinkedHashMap());
            this.patternProperties.put(name, (JsonSchema)schema.build());
            return this;
        }

        public Builder additionalProperties(Boolean enable) {
            this.additionalProperties = enable;
            return this;
        }

        public Builder additionalProperties(JsonSchema.Builder<?, ?, ?> schema) {
            return this.additionalProperties((JsonSchema)schema.build());
        }

        public Builder additionalProperties(JsonSchema schema) {
            this.additionalProperties = schema;
            return this;
        }

        public Builder required(String ... required) {
            return this.required(List.of(required));
        }

        public Builder required(List<String> required) {
            this.required = required;
            return this;
        }

        public Builder oneOf(RequiredSchema.Builder ... oneOf) {
            return (Builder)super.oneOf((JsonSchema.Builder[])oneOf);
        }

        @Override
        public Builder oneOf(List<RequiredSchema.Builder> oneOf) {
            return (Builder)super.oneOf(oneOf);
        }

        public Builder anyOf(RequiredSchema.Builder ... anyOf) {
            return this.anyOf(List.of(anyOf));
        }

        public Builder anyOf(List<RequiredSchema.Builder> anyOf) {
            this.anyOf = anyOf.stream().map(RequiredSchema.Builder::build).toList();
            return this;
        }

        @Override
        public ObjectSchema build() {
            return new ObjectSchema(this);
        }
    }
}

