/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model.schema;

import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import java.util.List;

public final class IntegerSchema
extends JsonSchema {
    private final Integer minimum;
    private final Integer maximum;
    private final Integer exclusiveMinimum;
    private final Integer exclusiveMaximum;
    private final Integer multipleOf;

    private IntegerSchema(Builder builder) {
        super(builder.nullable ? List.of("integer", "null") : "integer", builder);
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.exclusiveMinimum = builder.exclusiveMinimum;
        this.exclusiveMaximum = builder.exclusiveMaximum;
        this.multipleOf = builder.multipleOf;
    }

    public Integer minimum() {
        return this.minimum;
    }

    public Integer maximum() {
        return this.maximum;
    }

    public Integer exclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Integer exclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Integer multipleOf() {
        return this.multipleOf;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends JsonSchema.Builder<Builder, IntegerSchema, Builder> {
        private Integer minimum;
        private Integer maximum;
        private Integer exclusiveMinimum;
        private Integer exclusiveMaximum;
        private Integer multipleOf;

        private Builder() {
        }

        public Builder minimum(int minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder maximum(int maximum) {
            this.maximum = maximum;
            return this;
        }

        public Builder exclusiveMinimum(int exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
            return this;
        }

        public Builder exclusiveMaximum(int exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
            return this;
        }

        public Builder multipleOf(Integer multipleOf) {
            this.multipleOf = multipleOf;
            return this;
        }

        @Override
        public IntegerSchema build() {
            return new IntegerSchema(this);
        }
    }
}

