/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

public enum FinishReason {
    STOP("stop"),
    LENGTH("length"),
    TOOL_CALLS("tool_calls"),
    TIME_LIMIT("time_limit"),
    CANCELLED("cancelled"),
    ERROR("error"),
    INCOMPLETE(null);

    private final String value;

    private FinishReason(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static FinishReason fromValue(String value) {
        FinishReason finishReason;
        if (value == null) {
            finishReason = INCOMPLETE;
        } else {
            switch (value) {
                case "stop": {
                    finishReason = STOP;
                    break;
                }
                case "length": {
                    finishReason = LENGTH;
                    break;
                }
                case "tool_calls": {
                    finishReason = TOOL_CALLS;
                    break;
                }
                case "time_limit": {
                    finishReason = TIME_LIMIT;
                    break;
                }
                case "cancelled": {
                    finishReason = CANCELLED;
                    break;
                }
                case "error": {
                    finishReason = ERROR;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown finish reason: " + value);
                }
            }
        }
        return finishReason;
    }
}

