/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public final class ChatParameters
extends WatsonxParameters.WatsonxCryptoParameters {
    private final String toolChoiceOption;
    private final Map<String, Object> toolChoice;
    private final Set<String> guidedChoice;
    private final String guidedRegex;
    private final String guidedGrammar;
    private final Double frequencyPenalty;
    private final Map<String, Integer> logitBias;
    private final Boolean logprobs;
    private final Integer topLogprobs;
    private final Integer maxCompletionTokens;
    private final Integer n;
    private final Double presencePenalty;
    private final Integer seed;
    private final List<String> stop;
    private final Double temperature;
    private final Double topP;
    private final Long timeLimit;
    private final String responseFormat;
    private final JsonSchemaObject jsonSchema;
    private final Double repetitionPenalty;
    private final Double lengthPenalty;
    private final String context;

    private ChatParameters(Builder builder) {
        super(builder);
        this.toolChoiceOption = Objects.nonNull((Object)builder.toolChoiceOption) ? builder.toolChoiceOption.value() : null;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.logitBias = builder.logitBias;
        this.logprobs = builder.logprobs;
        this.topLogprobs = builder.topLogprobs;
        this.maxCompletionTokens = builder.maxCompletionTokens;
        this.n = builder.n;
        this.presencePenalty = builder.presencePenalty;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.timeLimit = builder.timeLimit;
        this.seed = builder.seed;
        this.stop = builder.stop;
        this.context = builder.context;
        if (Objects.nonNull((Object)builder.responseFormat)) {
            this.responseFormat = builder.responseFormat.value();
            this.jsonSchema = builder.jsonSchema;
        } else {
            this.responseFormat = null;
            this.jsonSchema = null;
        }
        this.toolChoice = Objects.nonNull(builder.toolChoice) ? Map.of("type", "function", "function", Map.of("name", builder.toolChoice)) : null;
        this.guidedChoice = builder.guidedChoice;
        this.guidedRegex = builder.guidedRegex;
        this.guidedGrammar = builder.guidedGrammar;
        this.repetitionPenalty = builder.repetitionPenalty;
        this.lengthPenalty = builder.lengthPenalty;
    }

    public String toolChoiceOption() {
        return this.toolChoiceOption;
    }

    public Map<String, Object> toolChoice() {
        return this.toolChoice;
    }

    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Boolean logprobs() {
        return this.logprobs;
    }

    public Integer topLogprobs() {
        return this.topLogprobs;
    }

    public Integer maxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public Integer n() {
        return this.n;
    }

    public Double presencePenalty() {
        return this.presencePenalty;
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public Long timeLimit() {
        return this.timeLimit;
    }

    public Integer seed() {
        return this.seed;
    }

    public List<String> stop() {
        return this.stop;
    }

    public String responseFormat() {
        return this.responseFormat;
    }

    public JsonSchemaObject jsonSchema() {
        return this.jsonSchema;
    }

    public Set<String> guidedChoice() {
        return this.guidedChoice;
    }

    public String guidedRegex() {
        return this.guidedRegex;
    }

    public String guidedGrammar() {
        return this.guidedGrammar;
    }

    public Double repetitionPenalty() {
        return this.repetitionPenalty;
    }

    public Double lengthPenalty() {
        return this.lengthPenalty;
    }

    public String context() {
        return this.context;
    }

    public Builder toBuilder() {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)new Builder().context(this.context).frequencyPenalty(this.frequencyPenalty).guidedChoice(this.guidedChoice).guidedGrammar(this.guidedGrammar).guidedRegex(this.guidedRegex).lengthPenalty(this.lengthPenalty).logitBias(this.logitBias).logprobs(this.logprobs).maxCompletionTokens(this.maxCompletionTokens).modelId(this.modelId)).n(this.n).presencePenalty(this.presencePenalty).projectId(this.projectId)).repetitionPenalty(this.repetitionPenalty).seed(this.seed).spaceId(this.spaceId)).stop(this.stop).temperature(this.temperature).timeLimit(Objects.nonNull(this.timeLimit) ? Duration.ofMillis(this.timeLimit) : null).toolChoice(Objects.nonNull(this.toolChoice) ? String.valueOf(((Map)this.toolChoice.get("function")).get("name")) : null).toolChoiceOption(Objects.nonNull(this.toolChoiceOption) ? ToolChoiceOption.valueOf(this.toolChoiceOption.toUpperCase()) : null).topLogprobs(this.topLogprobs).topP(this.topP).transactionId(this.transactionId)).crypto(this.crypto);
        builder.responseFormat = Objects.nonNull(this.responseFormat) ? ResponseFormat.valueOf(this.responseFormat.toUpperCase()) : null;
        builder.jsonSchema = this.jsonSchema;
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxParameters.WatsonxCryptoParameters.Builder<Builder> {
        private ToolChoiceOption toolChoiceOption;
        private String toolChoice;
        private Set<String> guidedChoice;
        private String guidedRegex;
        private String guidedGrammar;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer maxCompletionTokens;
        private Integer n;
        private Double presencePenalty;
        private ResponseFormat responseFormat;
        private Integer seed;
        private List<String> stop;
        private Double temperature;
        private Double topP;
        private Long timeLimit;
        private JsonSchemaObject jsonSchema;
        private Double repetitionPenalty;
        private Double lengthPenalty;
        private String context;

        private Builder() {
        }

        public Builder toolChoiceOption(ToolChoiceOption toolChoiceOption) {
            this.toolChoiceOption = toolChoiceOption;
            return this;
        }

        public Builder guidedChoice(String ... guidedChoice) {
            return this.guidedChoice(Set.of(guidedChoice));
        }

        public Builder guidedChoice(Set<String> guidedChoices) {
            this.guidedChoice = Objects.isNull(guidedChoices) ? null : Set.copyOf(guidedChoices);
            return this;
        }

        public Builder guidedRegex(String guidedRegex) {
            this.guidedRegex = guidedRegex;
            return this;
        }

        public Builder guidedGrammar(String guidedGrammar) {
            this.guidedGrammar = guidedGrammar;
            return this;
        }

        public Builder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = Objects.isNull(logitBias) ? null : Map.copyOf(logitBias);
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public Builder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder timeLimit(Duration timeLimit) {
            this.timeLimit = Objects.isNull(timeLimit) ? null : Long.valueOf(timeLimit.toMillis());
            return this;
        }

        public Builder responseAsText() {
            this.responseFormat = ResponseFormat.TEXT;
            return this;
        }

        public Builder responseAsJson() {
            this.responseFormat = ResponseFormat.JSON;
            return this;
        }

        public Builder responseAsJsonSchema(JsonSchema schema) {
            return this.responseAsJsonSchema(UUID.randomUUID().toString(), schema, true);
        }

        public Builder responseAsJsonSchema(String name, JsonSchema schema, boolean strict) {
            this.responseFormat = ResponseFormat.JSON_SCHEMA;
            this.jsonSchema = new JsonSchemaObject(name, schema, strict);
            return this;
        }

        public Builder responseAsJsonSchema(String name, Map<String, Object> schema, boolean strict) {
            this.responseFormat = ResponseFormat.JSON_SCHEMA;
            this.jsonSchema = new JsonSchemaObject(name, schema, strict);
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = Objects.isNull(stop) ? null : List.copyOf(stop);
            return this;
        }

        public Builder repetitionPenalty(Double repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public Builder lengthPenalty(Double lengthPenalty) {
            this.lengthPenalty = lengthPenalty;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public ChatParameters build() {
            return new ChatParameters(this);
        }
    }

    public static enum ToolChoiceOption {
        AUTO("auto"),
        REQUIRED("required"),
        NONE("none");

        private final String value;

        private ToolChoiceOption(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum ResponseFormat {
        TEXT("text"),
        JSON("json_object"),
        JSON_SCHEMA("json_schema");

        private final String value;

        private ResponseFormat(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public record JsonSchemaObject(String name, Object schema, boolean strict) {
    }
}

