/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.interceptor;

import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.interceptor.InterceptorContext;
import com.ibm.watsonx.ai.chat.model.CompletedToolCall;
import com.ibm.watsonx.ai.chat.model.FunctionCall;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import com.ibm.watsonx.ai.chat.model.ToolCall;
import java.util.List;
import java.util.Objects;

@FunctionalInterface
public interface ToolInterceptor {
    public FunctionCall intercept(InterceptorContext var1, FunctionCall var2);

    default public List<ChatResponse.ResultChoice> intercept(InterceptorContext context) {
        ChatResponse response = context.response().orElseThrow();
        return response.choices().stream().map(choice -> {
            ResultMessage message = choice.message();
            if (Objects.isNull(message.toolCalls())) {
                return choice;
            }
            List<ToolCall> toolCalls = message.toolCalls();
            List<FunctionCall> normalized = toolCalls.stream().map(tc -> this.intercept(context, tc.function())).toList();
            List<ToolCall> rebuiltToolCalls = toolCalls.stream().flatMap(tc -> normalized.stream().map(fc -> tc.withFunctionCall((FunctionCall)fc))).toList();
            ResultMessage resultMessage = new ResultMessage(message.role(), message.content(), message.reasoningContent(), message.refusal(), rebuiltToolCalls);
            return choice.withResultMessage(resultMessage);
        }).toList();
    }

    default public CompletedToolCall intercept(InterceptorContext context, CompletedToolCall completedToolCall) {
        FunctionCall normalized = this.intercept(context, completedToolCall.toolCall().function());
        return new CompletedToolCall(completedToolCall.completionId(), completedToolCall.index(), completedToolCall.toolCall().withFunctionCall(normalized));
    }
}

