/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.decorator;

import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.interceptor.InterceptorContext;
import com.ibm.watsonx.ai.chat.interceptor.ToolInterceptor;
import com.ibm.watsonx.ai.chat.model.CompletedToolCall;
import com.ibm.watsonx.ai.chat.model.PartialChatResponse;
import com.ibm.watsonx.ai.chat.model.PartialToolCall;
import com.ibm.watsonx.ai.core.provider.ExecutorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;

public class ChatHandlerDecorator
implements ChatHandler {
    private final ChatHandler delegate;
    private final InterceptorContext context;
    private final ToolInterceptor toolInterceptor;
    private final AtomicReference<CompletableFuture<Void>> callbackChain = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));
    private final List<CompletableFuture<CompletedToolCall>> pendingToolCallCallbacks = Collections.synchronizedList(new ArrayList());

    public ChatHandlerDecorator(ChatHandler delegate, InterceptorContext context, ToolInterceptor toolInterceptor) {
        this.delegate = delegate;
        this.context = context;
        this.toolInterceptor = toolInterceptor;
    }

    @Override
    public void onPartialResponse(String partialResponse, PartialChatResponse partialChatResponse) {
        this.scheduleCallback(() -> this.delegate.onPartialResponse(partialResponse, partialChatResponse));
    }

    @Override
    public void onCompleteResponse(ChatResponse completeResponse) {
        this.scheduleCallback(() -> this.delegate.onCompleteResponse(completeResponse));
    }

    @Override
    public void onError(Throwable error) {
        this.scheduleCallback(() -> this.delegate.onError(error));
    }

    @Override
    public void onPartialThinking(String partialThinking, PartialChatResponse partialChatResponse) {
        this.scheduleCallback(() -> this.delegate.onPartialThinking(partialThinking, partialChatResponse));
    }

    @Override
    public void onPartialToolCall(PartialToolCall partialToolCall) {
        this.scheduleCallback(() -> this.delegate.onPartialToolCall(partialToolCall));
    }

    @Override
    public void onCompleteToolCall(CompletedToolCall completeToolCall) {
        CompletionStage future = CompletableFuture.supplyAsync(() -> Objects.nonNull(this.toolInterceptor) ? this.toolInterceptor.intercept(this.context, completeToolCall) : completeToolCall, ExecutorProvider.callbackExecutor()).thenApplyAsync(toolCallNormalized -> {
            try {
                this.delegate.onCompleteToolCall((CompletedToolCall)toolCallNormalized);
                return toolCallNormalized;
            }
            catch (RuntimeException e) {
                this.delegate.onError(e);
                throw e;
            }
        }, ExecutorProvider.callbackExecutor());
        this.pendingToolCallCallbacks.add((CompletableFuture<CompletedToolCall>)future);
    }

    @Override
    public boolean failOnFirstError() {
        return this.delegate.failOnFirstError();
    }

    public CompletableFuture<List<CompletedToolCall>> awaitCallbacks() {
        return ((CompletableFuture)CompletableFuture.allOf(this.pendingToolCallCallbacks.toArray(new CompletableFuture[0])).thenCompose(v -> this.callbackChain.get())).thenApply(v -> this.pendingToolCallCallbacks.stream().map(CompletableFuture::join).toList());
    }

    private void scheduleCallback(Runnable callback) {
        this.callbackChain.updateAndGet(chain -> chain.thenRunAsync(() -> {
            try {
                callback.run();
            }
            catch (Exception e) {
                this.delegate.onError(e);
            }
        }, ExecutorProvider.callbackExecutor()));
    }
}

