/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.ToolExecutor;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.ToolArguments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ToolRegistry
implements ToolExecutor {
    private final Map<String, ExecutableTool> tools;
    private final ExecutableTool.BeforeExecution beforeExecution;
    private final ExecutableTool.AfterExecution afterExecution;
    private final ExecutableTool.OnError onError;

    public ToolRegistry(Builder builder) {
        if (builder.executableTools.isEmpty()) {
            throw new IllegalArgumentException("At least one tool must be provided");
        }
        this.tools = builder.executableTools.stream().collect(Collectors.toMap(ExecutableTool::name, t -> t));
        this.beforeExecution = builder.beforeExecution;
        this.afterExecution = builder.afterExecution;
        this.onError = builder.onError;
    }

    @Override
    public Object execute(String toolName, ToolArguments args) {
        ExecutableTool tool = this.tools.get(toolName);
        if (Objects.isNull(tool)) {
            throw new IllegalArgumentException("Unknown tool: " + toolName);
        }
        if (Objects.nonNull(this.beforeExecution)) {
            this.beforeExecution.accept(toolName, args);
        }
        try {
            String result = tool.execute(args);
            if (Objects.nonNull(this.afterExecution)) {
                this.afterExecution.accept(toolName, args, result);
            }
            return result;
        }
        catch (Exception e) {
            if (Objects.nonNull(this.onError)) {
                this.onError.accept(toolName, args, e);
            }
            throw e;
        }
    }

    public List<Tool> tools() {
        return this.tools(Set.of());
    }

    public List<Tool> tools(String ... names) {
        return this.tools(Set.of(names));
    }

    public List<Tool> tools(Set<String> names) {
        Stream<ExecutableTool> stream = this.tools.values().stream();
        if (!names.isEmpty()) {
            stream = stream.filter(tool -> names.contains(tool.name()));
        }
        return stream.map(ExecutableTool::schema).toList();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ExecutableTool> executableTools = Collections.synchronizedList(new ArrayList());
        private ExecutableTool.BeforeExecution beforeExecution;
        private ExecutableTool.AfterExecution afterExecution;
        private ExecutableTool.OnError onError;

        private Builder() {
        }

        public Builder beforeExecution(ExecutableTool.BeforeExecution beforeExecution) {
            this.beforeExecution = beforeExecution;
            return this;
        }

        public Builder afterExecution(ExecutableTool.AfterExecution afterExecution) {
            this.afterExecution = afterExecution;
            return this;
        }

        public Builder onError(ExecutableTool.OnError onError) {
            this.onError = onError;
            return this;
        }

        public Builder register(ExecutableTool ... executableTools) {
            return this.register(List.of(executableTools));
        }

        public Builder register(List<ExecutableTool> executableTools) {
            this.executableTools.addAll(executableTools);
            return this;
        }

        public ToolRegistry build() {
            return new ToolRegistry(this);
        }
    }
}

