/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.chat.ChatClientContext;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatProvider;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.ChatRestClient;
import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.interceptor.InterceptorContext;
import com.ibm.watsonx.ai.chat.interceptor.MessageInterceptor;
import com.ibm.watsonx.ai.chat.interceptor.ToolInterceptor;
import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ControlMessage;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.FinishReason;
import com.ibm.watsonx.ai.chat.model.PartialChatResponse;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.chat.model.Thinking;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.UserMessage;
import com.ibm.watsonx.ai.core.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatService
extends WatsonxService.CryptoService
implements ChatProvider {
    public static final Logger logger = LoggerFactory.getLogger(ChatService.class);
    private final ChatRestClient client;
    private final MessageInterceptor messageInterceptor;
    private final ToolInterceptor toolInterceptor;
    private final ChatProvider chatProvider;
    private final ChatParameters defaultParameters;
    private final List<Tool> defaultTools;

    private ChatService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.authenticator(), "authenticator cannot be null");
        this.messageInterceptor = builder.messageInterceptor;
        this.toolInterceptor = builder.toolInterceptor;
        this.defaultTools = builder.defaultTools;
        this.defaultParameters = Objects.requireNonNullElse(builder.defaultParameters, ChatParameters.builder().build());
        this.client = (ChatRestClient)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)ChatRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).httpClient(this.httpClient)).verifySsl(this.verifySsl)).authenticator(builder.authenticator())).build();
        this.chatProvider = Objects.nonNull(this.messageInterceptor) || Objects.nonNull(this.toolInterceptor) ? ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().authenticator(builder.authenticator())).baseUrl(this.baseUrl)).logRequests(this.logRequests)).logResponses(this.logResponses)).modelId(this.modelId)).projectId(this.projectId)).spaceId(this.spaceId)).timeout(this.timeout)).version(this.version)).parameters(this.defaultParameters).httpClient(this.httpClient)).verifySsl(this.verifySsl)).build() : null;
    }

    @Override
    public ChatResponse chat(ChatRequest chatRequest) {
        List<ChatResponse.ResultChoice> newChoices;
        Objects.requireNonNull(chatRequest, "chatRequest cannot be null");
        if (Objects.nonNull(chatRequest.deploymentId())) {
            logger.info("The deploymentId parameter can not be used with the ChatService. Use the DeploymentService instead");
        }
        TextChatRequest textChatRequest = this.buildTextChatRequest(chatRequest);
        ExtractionTags extractionTags = Objects.nonNull(chatRequest.thinking()) ? chatRequest.thinking().extractionTags() : null;
        String transactionId = Objects.nonNull(chatRequest.parameters()) ? chatRequest.parameters().transactionId() : null;
        ChatResponse chatResponse = this.client.chat(transactionId, textChatRequest);
        if (Objects.nonNull(this.messageInterceptor)) {
            newChoices = this.messageInterceptor.intercept(new InterceptorContext(this.chatProvider, chatRequest, chatResponse));
            chatResponse = chatResponse.toBuilder().choices(newChoices).build();
        }
        if (Objects.nonNull(this.toolInterceptor)) {
            newChoices = this.toolInterceptor.intercept(new InterceptorContext(this.chatProvider, chatRequest, chatResponse));
            chatResponse = chatResponse.toBuilder().choices(newChoices).build();
        }
        ChatResponse.Builder response = chatResponse.toBuilder();
        if (ChatParameters.ToolChoiceOption.REQUIRED.value().equals(textChatRequest.toolChoiceOption())) {
            response.choices(chatResponse.choices().stream().map(resultChoice -> resultChoice.withFinishReason(FinishReason.TOOL_CALLS)).toList());
        }
        return response.extractionTags(extractionTags).build();
    }

    @Override
    public CompletableFuture<ChatResponse> chatStreaming(ChatRequest chatRequest, ChatHandler handler) {
        Objects.requireNonNull(chatRequest, "chatRequest cannot be null");
        Objects.requireNonNull(handler, "The chatHandler parameter can not be null");
        if (Objects.nonNull(chatRequest.deploymentId())) {
            logger.info("The deploymentId parameter can not be used with the ChatService. Use the DeploymentService instead");
        }
        TextChatRequest textChatRequest = this.buildTextChatRequest(chatRequest);
        ExtractionTags extractionTags = Objects.nonNull(chatRequest.thinking()) ? chatRequest.thinking().extractionTags() : null;
        String transactionId = Objects.nonNull(chatRequest.parameters()) ? chatRequest.parameters().transactionId() : null;
        ChatClientContext context = ChatClientContext.builder().chatProvider(this.chatProvider).chatRequest(chatRequest).toolInterceptor(this.toolInterceptor).extractionTags(extractionTags).build();
        return this.client.chatStreaming(transactionId, textChatRequest, context, handler);
    }

    public ChatResponse chat(String message) {
        return this.chat(UserMessage.text(message));
    }

    public ChatResponse chat(ChatMessage ... messages) {
        return this.chat(Arrays.asList(messages));
    }

    public ChatResponse chat(List<ChatMessage> messages) {
        return this.chat(messages, ChatParameters.builder().build());
    }

    public ChatResponse chat(List<ChatMessage> messages, Tool ... tools) {
        return this.chat(messages, Arrays.asList(tools));
    }

    public ChatResponse chat(List<ChatMessage> messages, List<Tool> tools) {
        return this.chat(messages, null, tools);
    }

    public ChatResponse chat(List<ChatMessage> messages, ChatParameters parameters) {
        return this.chat(messages, parameters, null);
    }

    public ChatResponse chat(List<ChatMessage> messages, ChatParameters parameters, List<Tool> tools) {
        return this.chat(ChatRequest.builder().messages(messages).parameters(parameters).tools(Objects.isNull(tools) ? this.defaultTools : tools).build());
    }

    public CompletableFuture<ChatResponse> chatStreaming(String message, ChatHandler handler) {
        return this.chatStreaming(List.of(UserMessage.text(message)), handler);
    }

    public CompletableFuture<ChatResponse> chatStreaming(List<ChatMessage> messages, ChatHandler handler) {
        return this.chatStreaming(messages, ChatParameters.builder().build(), handler);
    }

    public CompletableFuture<ChatResponse> chatStreaming(List<ChatMessage> messages, List<Tool> tools, ChatHandler handler) {
        return this.chatStreaming(messages, null, tools, handler);
    }

    public CompletableFuture<ChatResponse> chatStreaming(List<ChatMessage> messages, ChatParameters parameters, ChatHandler handler) {
        return this.chatStreaming(messages, parameters, null, handler);
    }

    public CompletableFuture<ChatResponse> chatStreaming(String message, Consumer<String> handler) {
        return this.chatStreaming(List.of(UserMessage.text(message)), handler);
    }

    public CompletableFuture<ChatResponse> chatStreaming(List<ChatMessage> messages, Consumer<String> handler) {
        return this.chatStreaming(messages, ChatParameters.builder().build(), handler);
    }

    public CompletableFuture<ChatResponse> chatStreaming(List<ChatMessage> messages, ChatParameters parameters, Consumer<String> handler) {
        return this.chatStreaming(messages, parameters, null, handler);
    }

    public CompletableFuture<ChatResponse> chatStreaming(List<ChatMessage> messages, List<Tool> tools, Consumer<String> handler) {
        return this.chatStreaming(messages, null, tools, handler);
    }

    public CompletableFuture<ChatResponse> chatStreaming(List<ChatMessage> messages, ChatParameters parameters, List<Tool> tools, final Consumer<String> handler) {
        return this.chatStreaming(messages, parameters, tools, new ChatHandler(){

            @Override
            public void onPartialResponse(String partialResponse, PartialChatResponse partialChatResponse) {
                handler.accept(partialResponse);
            }
        });
    }

    public CompletableFuture<ChatResponse> chatStreaming(List<ChatMessage> messages, ChatParameters parameters, List<Tool> tools, ChatHandler handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).parameters(parameters).tools(Objects.isNull(tools) ? this.defaultTools : tools).build();
        return this.chatStreaming(chatRequest, handler);
    }

    public static Builder builder() {
        return new Builder();
    }

    private TextChatRequest buildTextChatRequest(ChatRequest chatRequest) {
        List<ChatMessage> messages = chatRequest.messages();
        List<Tool> tools = Objects.nonNull(chatRequest.tools()) && !chatRequest.tools().isEmpty() ? chatRequest.tools() : null;
        ChatParameters parameters = Objects.requireNonNullElse(chatRequest.parameters(), ChatParameters.builder().build());
        if (messages.stream().anyMatch(ControlMessage.class::isInstance) && (Objects.isNull(chatRequest.thinking()) || Objects.isNull(chatRequest.thinking().extractionTags()))) {
            throw new IllegalArgumentException("Extraction tags are required when using control messages");
        }
        WatsonxService.ProjectService.ProjectSpace projectSpace = this.resolveProjectSpace(parameters);
        String projectId = projectSpace.projectId();
        String spaceId = projectSpace.spaceId();
        String modelId = Objects.requireNonNullElse(parameters.modelId(), this.modelId);
        Long timeout = Objects.requireNonNullElse(this.defaultParameters.timeLimit(), this.timeout.toMillis());
        Boolean includeReasoning = null;
        String thinkingEffort = null;
        Map<String, Object> chatTemplateKwargs = null;
        if (Objects.nonNull(chatRequest.thinking())) {
            Thinking thinking = chatRequest.thinking();
            includeReasoning = thinking.includeReasoning();
            String string = thinkingEffort = Objects.nonNull((Object)thinking.thinkingEffort()) ? thinking.thinkingEffort().getValue() : null;
            if (Objects.nonNull(thinking.enabled())) {
                chatTemplateKwargs = Map.of("thinking", thinking.enabled());
            }
        }
        return TextChatRequest.builder().modelId(modelId).projectId(projectId).spaceId(spaceId).messages(messages).tools(tools).toolChoiceOption((String)Utils.getOrDefault((Object)parameters.toolChoiceOption(), (Object)this.defaultParameters.toolChoiceOption())).toolChoice((Map)Utils.getOrDefault(parameters.toolChoice(), this.defaultParameters.toolChoice())).frequencyPenalty((Double)Utils.getOrDefault((Object)parameters.frequencyPenalty(), (Object)this.defaultParameters.frequencyPenalty())).logitBias((Map)Utils.getOrDefault(parameters.logitBias(), this.defaultParameters.logitBias())).logprobs((Boolean)Utils.getOrDefault((Object)parameters.logprobs(), (Object)this.defaultParameters.logprobs())).topLogprobs((Integer)Utils.getOrDefault((Object)parameters.topLogprobs(), (Object)this.defaultParameters.topLogprobs())).maxCompletionTokens((Integer)Utils.getOrDefault((Object)parameters.maxCompletionTokens(), (Object)this.defaultParameters.maxCompletionTokens())).n((Integer)Utils.getOrDefault((Object)parameters.n(), (Object)this.defaultParameters.n())).presencePenalty((Double)Utils.getOrDefault((Object)parameters.presencePenalty(), (Object)this.defaultParameters.presencePenalty())).seed((Integer)Utils.getOrDefault((Object)parameters.seed(), (Object)this.defaultParameters.seed())).stop((List)Utils.getOrDefault(parameters.stop(), this.defaultParameters.stop())).temperature((Double)Utils.getOrDefault((Object)parameters.temperature(), (Object)this.defaultParameters.temperature())).topP((Double)Utils.getOrDefault((Object)parameters.topP(), (Object)this.defaultParameters.topP())).responseFormat((String)Utils.getOrDefault((Object)parameters.responseFormat(), (Object)this.defaultParameters.responseFormat())).jsonSchema((ChatParameters.JsonSchemaObject)Utils.getOrDefault((Object)parameters.jsonSchema(), (Object)this.defaultParameters.jsonSchema())).context((String)Utils.getOrDefault((Object)parameters.context(), (Object)this.defaultParameters.context())).timeLimit((Long)Utils.getOrDefault((Object)parameters.timeLimit(), (Object)timeout)).guidedChoice((Set)Utils.getOrDefault(parameters.guidedChoice(), this.defaultParameters.guidedChoice())).guidedRegex((String)Utils.getOrDefault((Object)parameters.guidedRegex(), (Object)this.defaultParameters.guidedRegex())).guidedGrammar((String)Utils.getOrDefault((Object)parameters.guidedGrammar(), (Object)this.defaultParameters.guidedGrammar())).repetitionPenalty((Double)Utils.getOrDefault((Object)parameters.repetitionPenalty(), (Object)this.defaultParameters.repetitionPenalty())).lengthPenalty((Double)Utils.getOrDefault((Object)parameters.lengthPenalty(), (Object)this.defaultParameters.lengthPenalty())).includeReasoning(includeReasoning).reasoningEffort(thinkingEffort).chatTemplateKwargs(chatTemplateKwargs).crypto((String)Utils.getOrDefault((Object)parameters.crypto(), (Object)this.defaultParameters.crypto())).build();
    }

    public static final class Builder
    extends WatsonxService.CryptoService.Builder<Builder> {
        private MessageInterceptor messageInterceptor;
        private ToolInterceptor toolInterceptor;
        private ChatParameters defaultParameters;
        private List<Tool> defaultTools;

        private Builder() {
        }

        public Builder parameters(ChatParameters parameters) {
            this.defaultParameters = parameters;
            return this;
        }

        public Builder messageInterceptor(MessageInterceptor messageInterceptor) {
            this.messageInterceptor = messageInterceptor;
            return this;
        }

        public Builder toolInterceptor(ToolInterceptor toolInterceptor) {
            this.toolInterceptor = toolInterceptor;
            return this;
        }

        public Builder tools(ExecutableTool ... executableTools) {
            return this.tools(Arrays.stream(executableTools).map(ExecutableTool::schema).toList());
        }

        public Builder tools(Tool ... tools) {
            return this.tools(Arrays.asList(tools));
        }

        public Builder tools(List<Tool> tools) {
            this.defaultTools = tools;
            return this;
        }

        public ChatService build() {
            return new ChatService(this);
        }
    }
}

