/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool.builtin;

import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.spi.json.TypeToken;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolService;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental
public final class TavilySearchTool {
    private final ToolService toolService;
    private final String apiKey;

    public TavilySearchTool(ToolService toolService, String apiKey) {
        this.toolService = Objects.requireNonNull(toolService, "ToolService can't be null");
        this.apiKey = Objects.requireNonNull(apiKey, "ApiKey can't be null");
    }

    public List<TavilySearchResult> search(String query) {
        return this.search(query, 10);
    }

    public List<TavilySearchResult> search(String query, Integer maxResults) {
        Objects.requireNonNull(query, "input can't be null");
        maxResults = Objects.requireNonNullElse(maxResults, 10);
        Map<String, Object> structuredInput = Map.of("query", query);
        Map<String, Object> config = Map.of("apiKey", this.apiKey, "maxResults", maxResults);
        String result = this.toolService.run(ToolRequest.structuredInput("TavilySearch", structuredInput, config));
        return (List)Json.fromJson((String)result, (TypeToken)new TypeToken<List<TavilySearchResult>>(){});
    }

    public record TavilySearchResult(String title, String url, String content, Double score) {
    }
}

