/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool.builtin;

import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.spi.json.TypeToken;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolService;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental
public final class GoogleSearchTool {
    private final ToolService toolService;

    public GoogleSearchTool(ToolService toolService) {
        this.toolService = Objects.requireNonNull(toolService, "ToolService can't be null");
    }

    public List<GoogleSearchResult> search(String query) {
        return this.search(query, 10);
    }

    public List<GoogleSearchResult> search(String query, Integer maxResults) {
        Objects.requireNonNull(query, "input can't be null");
        maxResults = Objects.requireNonNullElse(maxResults, 10);
        Map<String, Object> structuredInput = Map.of("q", query);
        Map<String, Object> config = Map.of("maxResults", maxResults);
        String result = this.toolService.run(ToolRequest.structuredInput("GoogleSearch", structuredInput, config));
        return (List)Json.fromJson((String)result, (TypeToken)new TypeToken<List<GoogleSearchResult>>(){});
    }

    public record GoogleSearchResult(String title, String description, String url) {
    }
}

