/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool;

import com.ibm.watsonx.ai.CloudRegion;
import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.tool.ToolParameters;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolRestClient;
import com.ibm.watsonx.ai.tool.UtilityTool;
import java.util.List;
import java.util.Objects;

@Experimental
public final class ToolService
extends WatsonxService {
    private final ToolRestClient client;

    private ToolService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
        this.client = (ToolRestClient)((ToolRestClient.Builder)((ToolRestClient.Builder)((ToolRestClient.Builder)((ToolRestClient.Builder)((ToolRestClient.Builder)((ToolRestClient.Builder)ToolRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticationProvider(builder.getAuthenticationProvider())).build();
    }

    public Resources getAll() {
        return this.getAll(ToolParameters.builder().build());
    }

    public Resources getAll(ToolParameters parameters) {
        return this.client.getAll(Objects.nonNull(parameters) ? parameters.getTransactionId() : null);
    }

    public UtilityTool getByName(String name) {
        return this.getByName(name, ToolParameters.builder().build());
    }

    public UtilityTool getByName(String name, ToolParameters parameters) {
        Objects.requireNonNull(name, "The name of the tool must be provided");
        String transactionId = Objects.nonNull(parameters) ? parameters.getTransactionId() : null;
        return this.client.getByName(transactionId, name);
    }

    public String run(ToolRequest toolRequest) {
        return this.run(toolRequest, ToolParameters.builder().build());
    }

    public String run(ToolRequest toolRequest, ToolParameters parameters) {
        Objects.requireNonNull(toolRequest, "The tool run request must be provided");
        Objects.requireNonNull(toolRequest.toolName(), "The name of the tool must be provided");
        Objects.requireNonNull(toolRequest.input(), "The input of the tool must be provided");
        String transactionId = Objects.nonNull(parameters) ? parameters.getTransactionId() : null;
        return this.client.run(transactionId, toolRequest);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxService.Builder<Builder> {
        private Builder() {
        }

        @Override
        public Builder baseUrl(CloudRegion url) {
            return (Builder)super.baseUrl(url.getWxEndpoint());
        }

        public ToolService build() {
            return new ToolService(this);
        }
    }

    public record Resources(List<UtilityTool> resources) {
    }
}

