/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.timeseries;

import com.ibm.watsonx.ai.timeseries.ForecastData;
import com.ibm.watsonx.ai.timeseries.InputSchema;
import com.ibm.watsonx.ai.timeseries.TimeSeriesParameters;
import java.util.Objects;

public final class TimeSeriesRequest {
    private String deploymentId;
    private InputSchema inputSchema;
    private ForecastData data;
    private TimeSeriesParameters parameters;

    protected TimeSeriesRequest(Builder builder) {
        this.inputSchema = Objects.requireNonNull(builder.inputSchema, "InputSchema cannot be null");
        this.data = Objects.requireNonNull(builder.data, "Data cannot be null");
        this.parameters = builder.parameters;
        this.deploymentId = builder.deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public InputSchema getInputSchema() {
        return this.inputSchema;
    }

    public ForecastData getData() {
        return this.data;
    }

    public TimeSeriesParameters getParameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deploymentId;
        private InputSchema inputSchema;
        private ForecastData data;
        private TimeSeriesParameters parameters;

        private Builder() {
        }

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder inputSchema(InputSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public Builder data(ForecastData data) {
            this.data = data;
            return this;
        }

        public Builder parameters(TimeSeriesParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public TimeSeriesRequest build() {
            return new TimeSeriesRequest(this);
        }
    }
}

