/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing.textextraction;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.textprocessing.CosReference;
import com.ibm.watsonx.ai.textprocessing.Language;
import com.ibm.watsonx.ai.textprocessing.OcrMode;
import com.ibm.watsonx.ai.textprocessing.textextraction.Parameters;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionSemanticConfig;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class TextExtractionParameters
extends WatsonxParameters {
    private final List<String> requestedOutputs;
    private final String mode;
    private final String ocrMode;
    private final List<String> languages;
    private final Boolean autoRotationCorrection;
    private final String createEmbeddedImages;
    private final Integer outputDpi;
    private final Boolean outputTokens;
    private final String kvpMode;
    private final TextExtractionSemanticConfig semanticConfig;
    private final boolean removeUploadedFile;
    private final boolean removeOutputFile;
    private final String outputFileName;
    private final CosReference documentReference;
    private final CosReference resultReference;
    private final Map<String, Object> custom;
    private final Duration timeout;

    public TextExtractionParameters(Builder builder) {
        super(builder);
        this.requestedOutputs = Objects.requireNonNullElse(builder.requestedOutputs, List.of(Type.MD.value));
        this.mode = builder.mode;
        this.ocrMode = builder.ocrMode;
        this.languages = builder.languages;
        this.autoRotationCorrection = builder.autoRotationCorrection;
        this.createEmbeddedImages = builder.createEmbeddedImages;
        this.outputDpi = builder.outputDpi;
        this.outputTokens = builder.outputTokens;
        this.kvpMode = builder.kvpMode;
        this.semanticConfig = builder.semanticConfig;
        this.removeUploadedFile = builder.removeUploadedFile;
        this.removeOutputFile = builder.removeOutputFile;
        this.outputFileName = builder.outputFileName;
        this.documentReference = builder.documentReference;
        this.resultReference = builder.resultReference;
        this.custom = builder.custom;
        this.timeout = Objects.requireNonNullElse(builder.timeout, Duration.ofSeconds(30L));
    }

    public List<String> getRequestedOutputs() {
        return this.requestedOutputs;
    }

    public String getMode() {
        return this.mode;
    }

    public String getOcrMode() {
        return this.ocrMode;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public Boolean getAutoRotationCorrection() {
        return this.autoRotationCorrection;
    }

    public String getCreateEmbeddedImages() {
        return this.createEmbeddedImages;
    }

    public Integer getOutputDpi() {
        return this.outputDpi;
    }

    public Boolean getOutputTokens() {
        return this.outputTokens;
    }

    public String getKvpMode() {
        return this.kvpMode;
    }

    public TextExtractionSemanticConfig getSemanticConfig() {
        return this.semanticConfig;
    }

    public boolean isRemoveUploadedFile() {
        return this.removeUploadedFile;
    }

    public boolean isRemoveOutputFile() {
        return this.removeOutputFile;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public CosReference getDocumentReference() {
        return this.documentReference;
    }

    public CosReference getResultReference() {
        return this.resultReference;
    }

    public Map<String, Object> getCustom() {
        return this.custom;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Parameters toParameters() {
        Parameters.SemanticConfig semanticConfig = Objects.isNull(this.getSemanticConfig()) ? null : new Parameters.SemanticConfig(this.semanticConfig.getEnableTextHints(), this.semanticConfig.getEnableGenericKvp(), this.semanticConfig.getEnableSchemaKvp(), this.semanticConfig.getGroundingMode(), this.semanticConfig.getForceSchemaName(), this.semanticConfig.getDefaultModelName(), this.semanticConfig.getTaskModelNameOverride(), this.semanticConfig.getSchemasMergeStrategy(), this.semanticConfig.getSchemas());
        return new Parameters(this.getRequestedOutputs(), this.getMode(), this.getOcrMode(), this.getLanguages(), this.getAutoRotationCorrection(), this.getCreateEmbeddedImages(), this.getOutputDpi(), this.getOutputTokens(), this.getKvpMode(), semanticConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxParameters.Builder<Builder> {
        private List<String> requestedOutputs;
        private String mode;
        private String ocrMode;
        private List<String> languages;
        private Boolean autoRotationCorrection;
        private String createEmbeddedImages;
        private Integer outputDpi;
        private Boolean outputTokens;
        private String kvpMode;
        private TextExtractionSemanticConfig semanticConfig;
        private boolean removeUploadedFile = false;
        private boolean removeOutputFile = false;
        private String outputFileName;
        private CosReference documentReference;
        private CosReference resultReference;
        private Map<String, Object> custom;
        private Duration timeout;

        private Builder() {
        }

        public Builder requestedOutputs(List<Type> types) {
            this.requestedOutputs = types.stream().map(Type::value).toList();
            return this;
        }

        public Builder requestedOutputs(Type ... types) {
            return this.requestedOutputs(Arrays.asList(types));
        }

        public Builder mode(Mode mode) {
            this.mode = mode.value();
            return this;
        }

        public Builder ocrMode(OcrMode ocrMode) {
            this.ocrMode = switch (ocrMode) {
                case OcrMode.AUTO -> null;
                default -> ocrMode.value();
            };
            return this;
        }

        public Builder languages(List<String> languages) {
            this.languages = languages;
            return this;
        }

        public Builder languages(Language ... languages) {
            return this.languages(Stream.of(languages).map(Language::isoCode).toList());
        }

        public Builder autoRotationCorrection(boolean autoRotationCorrection) {
            this.autoRotationCorrection = autoRotationCorrection;
            return this;
        }

        public Builder createEmbeddedImages(EmbeddedImageMode embeddedImageMode) {
            Objects.requireNonNull(embeddedImageMode, "embeddedImageMode cannot be null");
            this.createEmbeddedImages = embeddedImageMode.value();
            return this;
        }

        public Builder outputDpi(int outputDpi) {
            this.outputDpi = outputDpi;
            return this;
        }

        public Builder outputTokens(boolean outputTokens) {
            this.outputTokens = outputTokens;
            return this;
        }

        public Builder kvpMode(KvpMode kvpMode) {
            Objects.requireNonNull(kvpMode, "kvpMode cannot be null");
            this.kvpMode = kvpMode.value();
            return this;
        }

        public Builder semanticConfig(TextExtractionSemanticConfig semanticConfig) {
            this.semanticConfig = semanticConfig;
            return this;
        }

        public Builder removeUploadedFile(boolean removeUploadedFile) {
            this.removeUploadedFile = removeUploadedFile;
            return this;
        }

        public Builder removeOutputFile(boolean removeOutputFile) {
            this.removeOutputFile = removeOutputFile;
            return this;
        }

        public Builder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            return this;
        }

        public Builder documentReference(CosReference documentReference) {
            this.documentReference = documentReference;
            return this;
        }

        public Builder resultReference(CosReference resultReference) {
            this.resultReference = resultReference;
            return this;
        }

        public Builder addCustomProperty(String key, Object value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.custom = Objects.requireNonNullElse(this.custom, new HashMap());
            this.custom.put(key, value);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public TextExtractionParameters build() {
            return new TextExtractionParameters(this);
        }
    }

    public static enum Type {
        JSON("assembly"),
        HTML("html"),
        MD("md"),
        PLAIN_TEXT("plain_text"),
        PAGE_IMAGES("page_images");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Type fromValue(String value) {
            return Stream.of(Type.values()).filter(status -> status.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown Type value: " + value));
        }
    }

    public static enum KvpMode {
        DISABLED("disabled"),
        INVOICE("invoice"),
        UBILL("ubill"),
        GENERIC_WITH_SEMANTIC("generic_with_semantic");

        private final String value;

        private KvpMode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum EmbeddedImageMode {
        DISABLED("disabled"),
        ENABLED_PLACEHOLDER("enabled_placeholder"),
        ENABLED_TEXT("enabled_text"),
        ENABLED_VERBALIZATION("enabled_verbalization"),
        ENABLED_VERBALIZATION_ALL("enabled_verbalization_all");

        private final String value;

        private EmbeddedImageMode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum Mode {
        STANDARD("standard"),
        HIGH_QUALITY("high_quality");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

