/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing.textextraction;

import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.exception.WatsonxException;
import com.ibm.watsonx.ai.core.factory.HttpClientFactory;
import com.ibm.watsonx.ai.core.http.AsyncHttpClient;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import com.ibm.watsonx.ai.textprocessing.DeleteFileRequest;
import com.ibm.watsonx.ai.textprocessing.ReadFileRequest;
import com.ibm.watsonx.ai.textprocessing.UploadRequest;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionDeleteParameters;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionFetchParameters;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionResponse;
import com.ibm.watsonx.ai.textprocessing.textextraction.TextExtractionRestClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

final class DefaultRestClient
extends TextExtractionRestClient {
    private final SyncHttpClient syncHttpClient;
    private final AsyncHttpClient asyncHttpClient;

    DefaultRestClient(Builder builder) {
        super(builder);
        Objects.requireNonNull(this.authenticationProvider, "authenticationProvider is mandatory");
        this.syncHttpClient = HttpClientFactory.createSync((AuthenticationProvider)this.authenticationProvider, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
        this.asyncHttpClient = HttpClientFactory.createAsync((AuthenticationProvider)this.authenticationProvider, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
    }

    @Override
    public boolean deleteFile(DeleteFileRequest request) throws FileNotFoundException {
        try {
            return this.asyncDeleteFile(request).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof WatsonxException) {
                WatsonxException ex = (WatsonxException)throwable;
                Exception mapped = this.mapIfCosFileNotFound(ex);
                if (mapped instanceof FileNotFoundException) {
                    FileNotFoundException fnf = (FileNotFoundException)mapped;
                    throw fnf;
                }
                throw ex;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Boolean> asyncDeleteFile(DeleteFileRequest request) {
        try {
            String fileName = request.fileName();
            String bucketName = request.bucketName();
            String encodedFileName = new URI(null, null, fileName, null).toASCIIString();
            URI uri = URI.create(this.cosUrl + "/%s/%s".formatted(bucketName, encodedFileName));
            HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).timeout(this.timeout).DELETE();
            if (Objects.nonNull(request.requestTrackingId())) {
                httpRequest.header("Watsonx-AI-SDK-Request-Id", request.requestTrackingId());
            }
            return this.asyncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString()).thenApply(response -> response.statusCode() == 204);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readFile(ReadFileRequest request) throws FileNotFoundException {
        try {
            String fileName = request.fileName();
            String bucketName = request.bucketName();
            String encodedFileName = new URI(null, null, fileName, null).toASCIIString();
            URI uri = URI.create(this.cosUrl + "/%s/%s".formatted(bucketName, encodedFileName));
            HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).timeout(this.timeout).GET();
            if (Objects.nonNull(request.requestTrackingId())) {
                httpRequest.header("Watsonx-AI-SDK-Request-Id", request.requestTrackingId());
            }
            return (String)this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString()).body();
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (WatsonxException e) {
            Exception mapped = this.mapIfCosFileNotFound(e);
            if (mapped instanceof FileNotFoundException) {
                FileNotFoundException fnf = (FileNotFoundException)mapped;
                throw fnf;
            }
            throw e;
        }
    }

    @Override
    public boolean upload(UploadRequest request) {
        try {
            HttpResponse response;
            String fileName = request.fileName();
            String bucketName = request.bucketName();
            InputStream is = request.is();
            String encodedFileName = new URI(null, null, fileName, null).toASCIIString();
            URI uri = URI.create(this.cosUrl + "/%s/%s".formatted(bucketName, encodedFileName));
            HttpRequest.Builder httpRequest = HttpRequest.newBuilder().uri(URI.create(uri.toASCIIString())).timeout(this.timeout).PUT(HttpRequest.BodyPublishers.ofInputStream(() -> is));
            if (Objects.nonNull(request.requestTrackingId())) {
                httpRequest.header("Watsonx-AI-SDK-Request-Id", request.requestTrackingId());
            }
            return (response = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString())).statusCode() == 200;
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean deleteExtraction(TextExtractionRestClient.DeleteExtractionRequest request) {
        String id = request.extractionId();
        TextExtractionDeleteParameters parameters = request.parameters();
        String projectId = parameters.getProjectId();
        String spaceId = parameters.getSpaceId();
        String queryParameters = parameters.getHardDelete().map(nullable -> this.getQueryParameters(projectId, spaceId).concat("&hard_delete=true")).orElse(this.getQueryParameters(projectId, spaceId));
        URI uri = URI.create(this.baseUrl + "/ml/v1/text/extractions/%s?%s".formatted(id, queryParameters));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).timeout(this.timeout).DELETE();
        if (Objects.nonNull(request.requestTrackingId())) {
            httpRequest.header("Watsonx-AI-SDK-Request-Id", request.requestTrackingId());
        }
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return true;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (WatsonxException e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public TextExtractionResponse fetchExtractionDetails(TextExtractionRestClient.FetchExtractionDetailsRequest request) {
        String id = request.extractionId();
        TextExtractionFetchParameters parameters = request.parameters();
        String projectId = parameters.getProjectId();
        String spaceId = parameters.getSpaceId();
        String queryParameters = this.getQueryParameters(projectId, spaceId);
        URI uri = URI.create(this.baseUrl + "/ml/v1/text/extractions/%s?%s".formatted(id, queryParameters));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).header("Accept", "application/json").timeout(this.timeout).GET();
        if (Objects.nonNull(request.requestTrackingId())) {
            httpRequest.header("Watsonx-AI-SDK-Request-Id", request.requestTrackingId());
        }
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (TextExtractionResponse)Json.fromJson((String)((String)httpReponse.body()), TextExtractionResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TextExtractionResponse startExtraction(TextExtractionRestClient.StartExtractionRequest request) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v1/text/extractions?version=%s".formatted(this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)request.textExtractionRequest()))).timeout(this.timeout);
        if (Objects.nonNull(request.requestTrackingId())) {
            httpRequest.header("Watsonx-AI-SDK-Request-Id", request.requestTrackingId());
        }
        if (Objects.nonNull(request.transactionId())) {
            httpRequest.header("X-Global-Transaction-Id", request.transactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (TextExtractionResponse)Json.fromJson((String)((String)httpReponse.body()), TextExtractionResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String getQueryParameters(String projectId, String spaceId) {
        if (Objects.nonNull(projectId)) {
            return "version=%s&project_id=%s".formatted(this.version, URLEncoder.encode(projectId, Charset.defaultCharset()));
        }
        return "version=%s&space_id=%s".formatted(this.version, URLEncoder.encode(spaceId, Charset.defaultCharset()));
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends TextExtractionRestClient.Builder {
        @Override
        public DefaultRestClient build() {
            return new DefaultRestClient(this);
        }
    }
}

