/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing.textclassification;

import com.ibm.watsonx.ai.WatsonxRestClient;
import com.ibm.watsonx.ai.textprocessing.DeleteFileRequest;
import com.ibm.watsonx.ai.textprocessing.UploadRequest;
import com.ibm.watsonx.ai.textprocessing.textclassification.DefaultRestClient;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationDeleteParameters;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationFetchParameters;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationRequest;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationResponse;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public abstract class TextClassificationRestClient
extends WatsonxRestClient {
    protected final String cosUrl;

    protected TextClassificationRestClient(Builder builder) {
        super(builder);
        this.cosUrl = Objects.requireNonNull(builder.cosUrl, "cosUrl cannot be null");
    }

    public abstract TextClassificationResponse startClassification(StartClassificationRequest var1);

    public abstract TextClassificationResponse fetchClassificationDetails(FetchClassificationDetailsRequest var1);

    public abstract boolean deleteClassification(DeleteClassificationRequest var1);

    public abstract boolean deleteFile(DeleteFileRequest var1);

    public abstract CompletableFuture<Boolean> asyncDeleteFile(DeleteFileRequest var1);

    public abstract boolean upload(UploadRequest var1);

    static Builder builder() {
        return ServiceLoader.load(TextClassificationRestClientBuilderFactory.class).findFirst().map(Supplier::get).orElse(DefaultRestClient.builder());
    }

    public static abstract class Builder
    extends WatsonxRestClient.Builder<TextClassificationRestClient, Builder> {
        private String cosUrl;

        public Builder cosUrl(String cosUrl) {
            this.cosUrl = cosUrl;
            return this;
        }
    }

    public static interface TextClassificationRestClientBuilderFactory
    extends Supplier<Builder> {
    }

    public record DeleteClassificationRequest(String requestTrackingId, String classificationId, TextClassificationDeleteParameters parameters) {
        public static DeleteClassificationRequest of(String requestTrackingId, String classificationId, TextClassificationDeleteParameters parameters) {
            return new DeleteClassificationRequest(requestTrackingId, classificationId, parameters);
        }
    }

    public record FetchClassificationDetailsRequest(String requestTrackingId, String classificationId, TextClassificationFetchParameters parameters) {
        public static FetchClassificationDetailsRequest of(String requestTrackingId, String classificationId, TextClassificationFetchParameters parameters) {
            return new FetchClassificationDetailsRequest(requestTrackingId, classificationId, parameters);
        }
    }

    public record StartClassificationRequest(String requestTrackingId, String transactionId, TextClassificationRequest textClassificationRequest) {
        public static StartClassificationRequest of(String requestTrackingId, String transactionId, TextClassificationRequest textClassificationRequest) {
            return new StartClassificationRequest(requestTrackingId, transactionId, textClassificationRequest);
        }
    }
}

