/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

public interface TextGenerationSubscriber {
    public void onNext(String var1);

    public void onError(Throwable var1);

    public void onComplete();

    public static Void handleError(Throwable t, TextGenerationHandler handler) {
        Optional.ofNullable(t).ifPresent(handler::onError);
        return null;
    }

    public static TextGenerationSubscriber createSubscriber(final TextGenerationHandler handler) {
        return new TextGenerationSubscriber(){
            private volatile String modelId;
            private volatile int inputTokenCount;
            private volatile int generatedTokenCount;
            private volatile String stopReason;
            private volatile boolean pendingSSEError = false;
            private final StringBuffer buffer = new StringBuffer();
            private final ReentrantLock callbackLock = new ReentrantLock();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(String partialMessage) {
                TextGenerationResponse.Result result;
                if (Objects.isNull(partialMessage) || partialMessage.isBlank()) {
                    return;
                }
                if (partialMessage.startsWith("event: error")) {
                    this.pendingSSEError = true;
                    return;
                }
                if (!partialMessage.startsWith("data:")) {
                    return;
                }
                String messageData = partialMessage.split("data: ")[1];
                if (this.pendingSSEError) {
                    this.pendingSSEError = false;
                    throw new RuntimeException(messageData);
                }
                TextGenerationResponse chunk = (TextGenerationResponse)Json.fromJson((String)messageData, TextGenerationResponse.class);
                if (chunk.results().size() == 0) {
                    return;
                }
                if (Objects.isNull(this.modelId) && Objects.nonNull(chunk.modelId())) {
                    this.modelId = chunk.modelId();
                }
                if (Objects.nonNull((result = chunk.results().get(0)).inputTokenCount())) {
                    this.inputTokenCount += result.inputTokenCount().intValue();
                }
                if (Objects.nonNull(result.generatedTokenCount())) {
                    this.generatedTokenCount += result.generatedTokenCount().intValue();
                }
                if (Objects.nonNull(result.stopReason())) {
                    this.stopReason = result.stopReason();
                }
                if (Objects.nonNull(result.generatedText()) && !result.generatedText().isEmpty()) {
                    this.buffer.append(result.generatedText());
                    try {
                        this.callbackLock.lock();
                        handler.onPartialResponse(result.generatedText());
                    }
                    finally {
                        this.callbackLock.unlock();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                try {
                    this.callbackLock.lock();
                    handler.onError(throwable);
                }
                finally {
                    this.callbackLock.unlock();
                }
            }

            @Override
            public void onComplete() {
                try {
                    List<TextGenerationResponse.Result> result = List.of(new TextGenerationResponse.Result(this.buffer.toString(), this.stopReason, this.generatedTokenCount, this.inputTokenCount, null, null, null, null));
                    try {
                        this.callbackLock.lock();
                        handler.onCompleteResponse(new TextGenerationResponse(this.modelId, null, null, result));
                    }
                    finally {
                        this.callbackLock.unlock();
                    }
                }
                catch (RuntimeException e) {
                    this.onError(e);
                }
            }
        };
    }
}

