/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import com.ibm.watsonx.ai.WatsonxParameters;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TextGenerationParameters
extends WatsonxParameters.WatsonxModelParameters {
    private final String decodingMethod;
    private final LengthPenalty lengthPenalty;
    private final Integer maxNewTokens;
    private final Integer minNewTokens;
    private final Integer randomSeed;
    private final List<String> stopSequences;
    private final Double temperature;
    private Long timeLimit;
    private final Integer topK;
    private final Double topP;
    private final Double repetitionPenalty;
    private final Integer truncateInputTokens;
    private final ReturnOptions returnOptions;
    private final Boolean includeStopSequence;
    private Map<String, String> promptVariables;

    public TextGenerationParameters(Builder builder) {
        super(builder);
        this.decodingMethod = builder.decodingMethod;
        this.lengthPenalty = builder.lengthPenalty;
        this.maxNewTokens = builder.maxNewTokens;
        this.minNewTokens = builder.minNewTokens;
        this.randomSeed = builder.randomSeed;
        this.stopSequences = builder.stopSequences;
        this.temperature = builder.temperature;
        this.timeLimit = builder.timeLimit;
        this.topK = builder.topK;
        this.topP = builder.topP;
        this.repetitionPenalty = builder.repetitionPenalty;
        this.truncateInputTokens = builder.truncateInputTokens;
        this.returnOptions = builder.returnOptions;
        this.includeStopSequence = builder.includeStopSequence;
        this.promptVariables = builder.promptVariables;
    }

    public String getDecodingMethod() {
        return this.decodingMethod;
    }

    public LengthPenalty getLengthPenalty() {
        return this.lengthPenalty;
    }

    public Integer getMaxNewTokens() {
        return this.maxNewTokens;
    }

    public Integer getMinNewTokens() {
        return this.minNewTokens;
    }

    public Integer getRandomSeed() {
        return this.randomSeed;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Long getTimeLimit() {
        return this.timeLimit;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Double getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public Integer getTruncateInputTokens() {
        return this.truncateInputTokens;
    }

    public ReturnOptions getReturnOptions() {
        return this.returnOptions;
    }

    public Boolean getIncludeStopSequence() {
        return this.includeStopSequence;
    }

    public Map<String, String> getPromptVariables() {
        return this.promptVariables;
    }

    public void setTimeLimit(Long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void setPromptVariables(Map<String, String> promptVariables) {
        this.promptVariables = promptVariables;
    }

    public TextGenerationParameters toSanitized() {
        Builder builder = new Builder().decodingMethod(this.decodingMethod).includeStopSequence(this.includeStopSequence).maxNewTokens(this.maxNewTokens).minNewTokens(this.minNewTokens).promptVariables(this.promptVariables).randomSeed(this.randomSeed).repetitionPenalty(this.repetitionPenalty).returnOptions(this.returnOptions).stopSequences(this.stopSequences).temperature(this.temperature).topK(this.topK).topP(this.topP).truncateInputTokens(this.truncateInputTokens);
        if (Objects.nonNull(this.lengthPenalty)) {
            builder.lengthPenalty(this.lengthPenalty.decayFactor(), this.lengthPenalty.startIndex());
        }
        if (Objects.nonNull(this.timeLimit)) {
            builder.timeLimit(Duration.ofMillis(this.timeLimit));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxParameters.WatsonxModelParameters.Builder<Builder> {
        private String decodingMethod;
        private LengthPenalty lengthPenalty;
        private Integer maxNewTokens;
        private Integer minNewTokens;
        private Integer randomSeed;
        private List<String> stopSequences;
        private Double temperature;
        private Long timeLimit;
        private Integer topK;
        private Double topP;
        private Double repetitionPenalty;
        private Integer truncateInputTokens;
        private ReturnOptions returnOptions;
        private Boolean includeStopSequence;
        private Map<String, String> promptVariables;

        private Builder() {
        }

        public Builder decodingMethod(String decodingMethod) {
            this.decodingMethod = decodingMethod;
            return this;
        }

        public Builder lengthPenalty(double decayFactor, int startIndex) {
            this.lengthPenalty = new LengthPenalty(decayFactor, startIndex);
            return this;
        }

        public Builder maxNewTokens(Integer maxNewTokens) {
            this.maxNewTokens = maxNewTokens;
            return this;
        }

        public Builder minNewTokens(Integer minNewTokens) {
            this.minNewTokens = minNewTokens;
            return this;
        }

        public Builder randomSeed(Integer randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public Builder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder timeLimit(Duration timeLimit) {
            this.timeLimit = Objects.isNull(timeLimit) ? null : Long.valueOf(timeLimit.toMillis());
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder repetitionPenalty(Double repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public Builder truncateInputTokens(Integer truncateInputTokens) {
            this.truncateInputTokens = truncateInputTokens;
            return this;
        }

        public Builder returnOptions(ReturnOptions returnOptions) {
            this.returnOptions = returnOptions;
            return this;
        }

        public Builder includeStopSequence(Boolean includeStopSequence) {
            this.includeStopSequence = includeStopSequence;
            return this;
        }

        public Builder promptVariables(Map<String, String> promptVariables) {
            this.promptVariables = promptVariables;
            return this;
        }

        public TextGenerationParameters build() {
            return new TextGenerationParameters(this);
        }
    }

    public record LengthPenalty(double decayFactor, int startIndex) {
    }

    public static class ReturnOptions {
        private final Boolean inputText;
        private final Boolean generatedText;
        private final Boolean inputTokens;
        private final Boolean tokenLogprobs;
        private final Boolean tokenRanks;
        private final Integer topNTokens;

        public ReturnOptions(Builder builder) {
            this.inputText = builder.inputText;
            this.generatedText = builder.generatedText;
            this.inputTokens = builder.inputTokens;
            this.tokenLogprobs = builder.tokenLogprobs;
            this.tokenRanks = builder.tokenRanks;
            this.topNTokens = builder.topNTokens;
        }

        public Boolean getInputText() {
            return this.inputText;
        }

        public Boolean getGeneratedText() {
            return this.generatedText;
        }

        public Boolean getInputTokens() {
            return this.inputTokens;
        }

        public Boolean getTokenLogprobs() {
            return this.tokenLogprobs;
        }

        public Boolean getTokenRanks() {
            return this.tokenRanks;
        }

        public Integer getTopN_Tokens() {
            return this.topNTokens;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Boolean inputText;
            private Boolean generatedText;
            private Boolean inputTokens;
            private Boolean tokenLogprobs;
            private Boolean tokenRanks;
            private Integer topNTokens;

            private Builder() {
            }

            public Builder inputText(boolean inputText) {
                this.inputText = inputText;
                return this;
            }

            public Builder generatedText(boolean generatedText) {
                this.generatedText = generatedText;
                return this;
            }

            public Builder inputTokens(boolean inputTokens) {
                this.inputTokens = inputTokens;
                return this;
            }

            public Builder tokenLogprobs(boolean tokenLogprobs) {
                this.tokenLogprobs = tokenLogprobs;
                return this;
            }

            public Builder tokenRanks(boolean tokenRanks) {
                this.tokenRanks = tokenRanks;
                return this;
            }

            public Builder topNTokens(int topNTokens) {
                this.topNTokens = topNTokens;
                return this;
            }

            public ReturnOptions build() {
                return new ReturnOptions(this);
            }
        }
    }
}

