/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import java.util.List;

public final class Moderation {
    private final Hap hap;
    private final Pii pii;
    private final GraniteGuardian graniteGuardian;
    private final List<InputRanges> inputRanges;

    public Moderation(Builder builder) {
        this.hap = builder.hap;
        this.pii = builder.pii;
        this.graniteGuardian = builder.graniteGuardian;
        this.inputRanges = builder.inputRanges;
    }

    public Hap getHap() {
        return this.hap;
    }

    public Pii getPii() {
        return this.pii;
    }

    public GraniteGuardian getGraniteGuardian() {
        return this.graniteGuardian;
    }

    public List<InputRanges> getInputRanges() {
        return this.inputRanges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Hap hap;
        private Pii pii;
        private GraniteGuardian graniteGuardian;
        private List<InputRanges> inputRanges;

        private Builder() {
        }

        public Builder hap(TextModeration input, TextModeration output, boolean mask) {
            this.hap = new Hap(input, output, new MaskProperties(mask));
            return this;
        }

        public Builder pii(boolean input, boolean output, boolean mask) {
            this.pii = new Pii(new TextModerationWithoutThreshold(input), new TextModerationWithoutThreshold(output), new MaskProperties(mask));
            return this;
        }

        public Builder graniteGuardian(TextModeration input, boolean mask) {
            this.graniteGuardian = new GraniteGuardian(input, new MaskProperties(mask));
            return this;
        }

        public Builder inputRanges(List<InputRanges> inputRanges) {
            this.inputRanges = inputRanges;
            return this;
        }

        public Moderation build() {
            return new Moderation(this);
        }
    }

    private record Hap(TextModeration input, TextModeration output, MaskProperties mask) {
    }

    record Pii(TextModerationWithoutThreshold input, TextModerationWithoutThreshold output, MaskProperties mask) {
    }

    record GraniteGuardian(TextModeration input, MaskProperties mask) {
    }

    public record InputRanges(Integer start, Integer end) {
        public static InputRanges of(Integer start, Integer end) {
            return new InputRanges(start, end);
        }
    }

    public record TextModerationWithoutThreshold(boolean enabled) {
    }

    public record MaskProperties(boolean removeEntityValue) {
    }

    public record TextModeration(boolean enabled, float threshold) {
        public static TextModeration of(float threshold) {
            return new TextModeration(true, threshold);
        }
    }
}

