/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.SseEventLogger;
import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.factory.HttpClientFactory;
import com.ibm.watsonx.ai.core.http.AsyncHttpClient;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import com.ibm.watsonx.ai.textgeneration.TextGenerationRestClient;
import com.ibm.watsonx.ai.textgeneration.TextGenerationSubscriber;
import com.ibm.watsonx.ai.textgeneration.TextRequest;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

final class DefaultRestClient
extends TextGenerationRestClient {
    private final SyncHttpClient syncHttpClient;
    private final AsyncHttpClient asyncHttpClient;

    DefaultRestClient(Builder builder) {
        super(builder);
        Objects.requireNonNull(this.authenticationProvider, "authenticationProvider is mandatory");
        this.syncHttpClient = HttpClientFactory.createSync((AuthenticationProvider)this.authenticationProvider, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
        this.asyncHttpClient = HttpClientFactory.createAsync((AuthenticationProvider)this.authenticationProvider, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
    }

    @Override
    public TextGenerationResponse generate(String transactionId, TextRequest textRequest) {
        Long timeout = textRequest.parameters().getTimeLimit();
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v1/text/generation?version=%s".formatted(this.version))).header("Content-Type", "application/json").header("Accept", "application/json").timeout(Duration.ofMillis(timeout)).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (TextGenerationResponse)Json.fromJson((String)((String)httpReponse.body()), TextGenerationResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> generateStreaming(String transactionId, TextRequest textRequest, TextGenerationHandler handler) {
        Long timeout = textRequest.parameters().getTimeLimit();
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v1/text/generation_stream?version=%s".formatted(this.version))).header("Content-Type", "application/json").header("Accept", "text/event-stream").timeout(Duration.ofMillis(timeout)).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        Flow.Subscriber<String> subscriber = this.subscriber(handler);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAccept(r -> {})).exceptionally(t -> TextGenerationSubscriber.handleError(t, handler));
    }

    private Flow.Subscriber<String> subscriber(final TextGenerationHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile boolean success = true;
            private volatile TextGenerationSubscriber chatSubscriber = TextGenerationSubscriber.createSubscriber(handler);

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(String partialMessage) {
                try {
                    this.chatSubscriber.onNext(partialMessage);
                }
                catch (RuntimeException e) {
                    this.onError(e);
                    this.success = !handler.failOnFirstError();
                }
                finally {
                    if (this.success) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                this.chatSubscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.chatSubscriber.onComplete();
            }
        };
    }

    static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends TextGenerationRestClient.Builder {
        private Builder() {
        }

        @Override
        public DefaultRestClient build() {
            return new DefaultRestClient(this);
        }
    }
}

