/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.foundationmodel;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.foundationmodel.FoundationModel;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelParameters;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelResponse;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelRestClient;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelTask;
import com.ibm.watsonx.ai.foundationmodel.filter.Filter;
import java.util.Objects;
import java.util.Optional;

public final class FoundationModelService
extends WatsonxService {
    private final boolean techPreview;
    private final FoundationModelRestClient client;

    private FoundationModelService(Builder builder) {
        super(builder);
        this.techPreview = Objects.requireNonNullElse(builder.techPreview, false);
        this.client = (FoundationModelRestClient)((FoundationModelRestClient.Builder)((FoundationModelRestClient.Builder)((FoundationModelRestClient.Builder)((FoundationModelRestClient.Builder)((FoundationModelRestClient.Builder)FoundationModelRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).build();
    }

    public FoundationModelResponse<FoundationModel> getModels() {
        return this.getModels(FoundationModelParameters.builder().build());
    }

    public FoundationModelResponse<FoundationModel> getModels(Filter filter) {
        return this.getModels(FoundationModelParameters.builder().filter(filter).build());
    }

    public FoundationModelResponse<FoundationModel> getModels(FoundationModelParameters parameters) {
        parameters = Objects.requireNonNullElse(parameters, FoundationModelParameters.builder().build());
        Boolean techPreview = Optional.ofNullable(parameters.getTechPreview()).orElse(this.techPreview);
        return this.getModels(parameters.getStart(), parameters.getLimit(), parameters.getTransactionId(), techPreview, parameters.getFilter());
    }

    protected FoundationModelResponse<FoundationModel> getModels(Integer start, Integer limit, String transactionId, Boolean techPreview, String filters) {
        return this.client.getModels(start, limit, transactionId, techPreview, filters);
    }

    public FoundationModelResponse<FoundationModelTask> getTasks() {
        return this.getTasks(FoundationModelParameters.builder().build());
    }

    public FoundationModelResponse<FoundationModelTask> getTasks(FoundationModelParameters parameters) {
        return this.client.getTasks(parameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxService.Builder<Builder> {
        private Boolean techPreview;

        private Builder() {
        }

        public Builder techPreview(boolean techPreview) {
            this.techPreview = techPreview;
            return this;
        }

        public FoundationModelService build() {
            return new FoundationModelService(this);
        }
    }
}

