/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.detection;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.detection.DetectionResponse;
import com.ibm.watsonx.ai.detection.DetectionRestClient;
import com.ibm.watsonx.ai.detection.DetectionTextRequest;
import com.ibm.watsonx.ai.detection.DetectionTextResponse;
import com.ibm.watsonx.ai.detection.TextDetectionContentDetectors;
import java.util.Objects;

public final class DetectionService
extends WatsonxService.ProjectService {
    private final DetectionRestClient client;

    private DetectionService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
        this.client = (DetectionRestClient)((DetectionRestClient.Builder)((DetectionRestClient.Builder)((DetectionRestClient.Builder)((DetectionRestClient.Builder)((DetectionRestClient.Builder)((DetectionRestClient.Builder)DetectionRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticationProvider(builder.getAuthenticationProvider())).build();
    }

    public DetectionResponse<DetectionTextResponse> detect(DetectionTextRequest request) {
        WatsonxService.ProjectService.ProjectSpace projectSpace = this.resolveProjectSpace(request);
        String transactionId = request.getTransactionId();
        TextDetectionContentDetectors textDetectionRequest = new TextDetectionContentDetectors(request.getInput(), request.getDetectors(), projectSpace.projectId(), projectSpace.spaceId());
        return this.client.detect(transactionId, textDetectionRequest);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxService.ProjectService.Builder<Builder> {
        private Builder() {
        }

        public DetectionService build() {
            return new DetectionService(this);
        }
    }
}

