/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.deployment;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatProvider;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.AssistantMessage;
import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.chat.model.Thinking;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.deployment.DeploymentResource;
import com.ibm.watsonx.ai.deployment.DeploymentRestClient;
import com.ibm.watsonx.ai.deployment.FindByIdRequest;
import com.ibm.watsonx.ai.textgeneration.Moderation;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationParameters;
import com.ibm.watsonx.ai.textgeneration.TextGenerationProvider;
import com.ibm.watsonx.ai.textgeneration.TextGenerationRequest;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import com.ibm.watsonx.ai.textgeneration.TextRequest;
import com.ibm.watsonx.ai.timeseries.ForecastData;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import com.ibm.watsonx.ai.timeseries.InputSchema;
import com.ibm.watsonx.ai.timeseries.TimeSeriesParameters;
import com.ibm.watsonx.ai.timeseries.TimeSeriesProvider;
import com.ibm.watsonx.ai.timeseries.TimeSeriesRequest;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeploymentService
extends WatsonxService
implements ChatProvider,
TextGenerationProvider,
TimeSeriesProvider {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);
    private final DeploymentRestClient client;

    private DeploymentService(Builder builder) {
        super(builder);
        this.client = (DeploymentRestClient)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)((DeploymentRestClient.Builder)DeploymentRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticationProvider(builder.getAuthenticationProvider())).build();
    }

    public DeploymentResource findById(FindByIdRequest parameters) {
        Objects.requireNonNull(parameters, "FindByIdRequest cannot be null");
        Objects.requireNonNull(parameters.getDeploymentId(), "deploymentId must be provided");
        if (Objects.isNull(parameters.getProjectId()) && Objects.isNull(parameters.getSpaceId())) {
            throw new IllegalArgumentException("Either projectId or spaceId must be provided");
        }
        return this.client.findById(parameters);
    }

    @Override
    public TextGenerationResponse generate(TextGenerationRequest textGenerationRequest) {
        Objects.requireNonNull(textGenerationRequest, "textGenerationRequest cannot be null");
        String input = textGenerationRequest.getInput();
        Moderation moderation = textGenerationRequest.getModeration();
        String deploymentId = Objects.requireNonNull(textGenerationRequest.getDeploymentId(), "deploymentId must be provided");
        TextGenerationParameters parameters = Objects.requireNonNullElse(textGenerationRequest.getParameters(), TextGenerationParameters.builder().build());
        Duration timeout = Duration.ofMillis(Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis()));
        this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
        TextRequest textRequest = new TextRequest(null, null, null, input, parameters.toSanitized(), moderation);
        DeploymentRestClient.GenerateRequest request = new DeploymentRestClient.GenerateRequest(parameters.getTransactionId(), deploymentId, timeout, textRequest);
        return this.client.generate(request);
    }

    @Override
    public CompletableFuture<Void> generateStreaming(TextGenerationRequest textGenerationRequest, TextGenerationHandler handler) {
        Objects.requireNonNull(textGenerationRequest, "textGenerationRequest cannot be null");
        String input = textGenerationRequest.getInput();
        String deploymentId = Objects.requireNonNull(textGenerationRequest.getDeploymentId(), "deploymentId must be provided");
        TextGenerationParameters parameters = Objects.requireNonNullElse(textGenerationRequest.getParameters(), TextGenerationParameters.builder().build());
        Duration timeout = Duration.ofMillis(Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis()));
        this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
        TextRequest textGenRequest = new TextRequest(null, null, null, input, parameters.toSanitized(), null);
        DeploymentRestClient.GenerateStreamingRequest request = new DeploymentRestClient.GenerateStreamingRequest(parameters.getTransactionId(), deploymentId, timeout, textGenRequest, handler);
        return this.client.generateStreaming(request);
    }

    @Override
    public ChatResponse chat(ChatRequest chatRequest) {
        AssistantMessage assistantMessage;
        Objects.requireNonNull(chatRequest, "chatRequest cannot be null");
        String deploymentId = Objects.requireNonNull(chatRequest.getDeploymentId(), "deploymentId must be provided");
        List<ChatMessage> messages = chatRequest.getMessages();
        List<Tool> tools = Objects.nonNull(chatRequest.getTools()) && !chatRequest.getTools().isEmpty() ? chatRequest.getTools() : null;
        ChatParameters parameters = chatRequest.getParameters();
        parameters = Objects.requireNonNullElse(parameters, ChatParameters.builder().build());
        Duration timeout = Duration.ofMillis(Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis()));
        this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
        TextChatRequest textChatRequest = TextChatRequest.builder().messages(messages).tools(tools).parameters(parameters).build();
        DeploymentRestClient.ChatRequest request = new DeploymentRestClient.ChatRequest(parameters.getTransactionId(), deploymentId, timeout, textChatRequest);
        ChatResponse chatResponse = this.client.chat(request);
        if (Objects.nonNull(parameters.getToolChoiceOption()) && parameters.getToolChoiceOption().equals(ChatParameters.ToolChoiceOption.REQUIRED.type()) && Objects.nonNull((assistantMessage = chatResponse.toAssistantMessage()).toolCalls()) && !assistantMessage.toolCalls().isEmpty()) {
            chatResponse.getChoices().get(0).setFinishReason("tool_calls");
        }
        return chatResponse;
    }

    @Override
    public CompletableFuture<Void> chatStreaming(ChatRequest chatRequest, ChatHandler handler) {
        Objects.requireNonNull(chatRequest, "chatRequest cannot be null");
        Objects.requireNonNull(handler, "The chatHandler parameter can not be null");
        String deploymentId = Objects.requireNonNull(chatRequest.getDeploymentId(), "deploymentId must be provided");
        List<ChatMessage> messages = chatRequest.getMessages();
        List<Tool> tools = Objects.nonNull(chatRequest.getTools()) && !chatRequest.getTools().isEmpty() ? chatRequest.getTools() : null;
        ChatParameters parameters = Objects.requireNonNullElse(chatRequest.getParameters(), ChatParameters.builder().build());
        Duration timeout = Duration.ofMillis(Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis()));
        Boolean includeReasoning = null;
        String thinkingEffort = null;
        ExtractionTags extractionTags = null;
        Map<String, Object> chatTemplateKwargs = null;
        if (Objects.nonNull(chatRequest.getThinking())) {
            Thinking thinking = chatRequest.getThinking();
            chatTemplateKwargs = Map.of("thinking", true);
            extractionTags = thinking.getExtractionTags();
            includeReasoning = thinking.getIncludeReasoning();
            thinkingEffort = Objects.nonNull((Object)thinking.getThinkingEffort()) ? thinking.getThinkingEffort().getValue() : null;
        }
        this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
        TextChatRequest textChatRequest = TextChatRequest.builder().messages(messages).tools(tools).parameters(parameters).includeReasoning(includeReasoning).reasoningEffort(thinkingEffort).chatTemplateKwargs(chatTemplateKwargs).build();
        DeploymentRestClient.ChatStreamingRequest request = new DeploymentRestClient.ChatStreamingRequest(parameters.getTransactionId(), deploymentId, timeout, extractionTags, textChatRequest, handler);
        return this.client.chatStreaming(request);
    }

    @Override
    public ForecastResponse forecast(TimeSeriesRequest timeSeriesRequest) {
        Objects.requireNonNull(timeSeriesRequest, "timeSeriesRequest cannot be null");
        String deploymentId = Objects.requireNonNull(timeSeriesRequest.getDeploymentId(), "deploymentId must be provided");
        InputSchema inputSchema = timeSeriesRequest.getInputSchema();
        ForecastData data = timeSeriesRequest.getData();
        TimeSeriesParameters parameters = timeSeriesRequest.getParameters();
        ForecastRequest.Parameters requestParameters = null;
        Map futureData = null;
        String transactionId = null;
        if (Objects.nonNull(parameters)) {
            this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
            requestParameters = parameters.toParameters();
            futureData = Optional.ofNullable(parameters.getFutureData()).map(p -> p.asMap()).orElse(null);
            transactionId = parameters.getTransactionId();
        }
        ForecastRequest forecastRequest = new ForecastRequest(null, null, null, data.asMap(), inputSchema, futureData, requestParameters);
        DeploymentRestClient.ForecastRequest request = new DeploymentRestClient.ForecastRequest(transactionId, deploymentId, this.timeout, forecastRequest);
        return this.client.forecast(request);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void logIgnoredParameters(String modelId, String projectId, String spaceId) {
        if (Objects.nonNull(modelId)) {
            logger.info("The modelId parameter is ignored for the DeploymentService");
        }
        if (Objects.nonNull(projectId)) {
            logger.info("The projectId parameter is ignored for the DeploymentService");
        }
        if (Objects.nonNull(spaceId)) {
            logger.info("The spaceId parameter is ignored for the DeploymentService");
        }
    }

    public static final class Builder
    extends WatsonxService.Builder<Builder> {
        private Builder() {
        }

        public DeploymentService build() {
            return new DeploymentService(this);
        }
    }
}

