/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model.schema;

import com.ibm.watsonx.ai.chat.model.schema.Format;
import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import java.util.List;
import java.util.Objects;

public final class StringSchema
extends JsonSchema {
    private final String pattern;
    private final Integer maxLength;
    private final Integer minLength;
    private final String format;

    private StringSchema(Builder builder) {
        super(builder.nullable ? List.of("string", "null") : "string", builder);
        this.pattern = builder.pattern;
        this.maxLength = builder.maxLength;
        this.minLength = builder.minLength;
        this.format = builder.format;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public String getFormat() {
        return this.format;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends JsonSchema.Builder<Builder, StringSchema> {
        private String pattern;
        private Integer minLength;
        private Integer maxLength;
        private String format;

        private Builder() {
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder minLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder format(Format format) {
            Objects.requireNonNull(format, "The format cannot be null");
            this.format = format.getValue();
            return this;
        }

        @Override
        public StringSchema build() {
            return new StringSchema(this);
        }
    }
}

