/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model.schema;

import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import java.util.List;
import java.util.Objects;

public final class ArraySchema
extends JsonSchema {
    private final JsonSchema items;
    private final JsonSchema contains;
    private final Integer minItems;
    private final Integer maxItems;

    private ArraySchema(Builder builder) {
        super(builder.nullable ? List.of("array", "null") : "array", builder);
        if (Objects.isNull(builder.items) && Objects.isNull(builder.contains)) {
            throw new IllegalArgumentException("Either items or contains must be specified");
        }
        this.items = builder.items;
        this.contains = builder.contains;
        this.minItems = builder.minItems;
        this.maxItems = builder.maxItems;
    }

    public JsonSchema getItems() {
        return this.items;
    }

    public JsonSchema getContains() {
        return this.contains;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends JsonSchema.Builder<Builder, ArraySchema> {
        private JsonSchema items;
        private JsonSchema contains;
        private Integer minItems;
        private Integer maxItems;

        private Builder() {
        }

        public Builder items(JsonSchema.Builder<?, ?> items) {
            this.items = items.build();
            return this;
        }

        public Builder contains(JsonSchema.Builder<?, ?> contains) {
            this.contains = contains.build();
            return this;
        }

        public Builder minItems(int minItems) {
            this.minItems = minItems;
            return this;
        }

        public Builder maxItems(int maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public ArraySchema build() {
            return new ArraySchema(this);
        }
    }
}

