/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.ChatRestClient;
import com.ibm.watsonx.ai.chat.ChatSubscriber;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.SseEventLogger;
import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.factory.HttpClientFactory;
import com.ibm.watsonx.ai.core.http.AsyncHttpClient;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

final class DefaultRestClient
extends ChatRestClient {
    private final SyncHttpClient syncHttpClient;
    private final AsyncHttpClient asyncHttpClient;

    DefaultRestClient(Builder builder) {
        super(builder);
        Objects.requireNonNull(this.authenticationProvider, "authenticationProvider is mandatory");
        this.syncHttpClient = HttpClientFactory.createSync((AuthenticationProvider)this.authenticationProvider, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
        this.asyncHttpClient = HttpClientFactory.createAsync((AuthenticationProvider)this.authenticationProvider, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
    }

    @Override
    public ChatResponse chat(String transactionId, TextChatRequest textChatRequest) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v1/text/chat?version=%s".formatted(this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(textChatRequest.getTimeLimit()));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ChatResponse)Json.fromJson((String)((String)httpReponse.body()), ChatResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> chatStreaming(String transactionId, ExtractionTags extractionTags, TextChatRequest textChatRequest, ChatHandler handler) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v1/text/chat_stream?version=%s".formatted(this.version))).header("Content-Type", "application/json").header("Accept", "text/event-stream").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(textChatRequest.getTimeLimit()));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        Flow.Subscriber<String> subscriber = this.subscriber(textChatRequest.getToolChoiceOption(), ChatSubscriber.toolHasParameters(textChatRequest.getTools()), extractionTags, handler);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAccept(r -> {})).exceptionally(t -> ChatSubscriber.handleError(t, handler));
    }

    private Flow.Subscriber<String> subscriber(final String toolChoiceOption, final Map<String, Boolean> toolHasParameters, final ExtractionTags extractionTags, final ChatHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile boolean success = true;
            private volatile ChatSubscriber chatSubscriber = ChatSubscriber.createSubscriber(toolChoiceOption, toolHasParameters, extractionTags, handler);

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(String partialMessage) {
                try {
                    this.chatSubscriber.onNext(partialMessage);
                }
                catch (RuntimeException e) {
                    this.onError(e);
                    this.success = !handler.failOnFirstError();
                }
                finally {
                    if (this.success) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                this.chatSubscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.chatSubscriber.onComplete();
            }
        };
    }

    static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ChatRestClient.Builder {
        private Builder() {
        }

        @Override
        public DefaultRestClient build() {
            return new DefaultRestClient(this);
        }
    }
}

