/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.model.AssistantMessage;
import com.ibm.watsonx.ai.chat.model.ChatUsage;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.FinishReason;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import com.ibm.watsonx.ai.core.Json;
import java.util.List;
import java.util.Objects;

public final class ChatResponse {
    private String id;
    private String object;
    private String modelId;
    private String model;
    private List<ResultChoice> choices;
    private Long created;
    private String modelVersion;
    private String createdAt;
    private ChatUsage usage;
    private ExtractionTags extractionTags;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getObject() {
        return this.object;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public void setChoices(List<ResultChoice> choices) {
        this.choices = choices;
    }

    public List<ResultChoice> getChoices() {
        return this.choices;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setUsage(ChatUsage usage) {
        this.usage = usage;
    }

    public ChatUsage getUsage() {
        return this.usage;
    }

    void setExtractionTags(ExtractionTags extractionTags) {
        this.extractionTags = extractionTags;
    }

    public String extractContent() {
        ResultMessage resultMessage = this.choices.get(0).getMessage();
        if (Objects.nonNull(resultMessage.toolCalls())) {
            throw new RuntimeException("The response is of the type \"tool_calls\" and contains no text");
        }
        if (Objects.isNull(this.extractionTags)) {
            return resultMessage.content();
        }
        String content = this.extractionTags.extractResponse(resultMessage.content());
        return Objects.isNull(content) ? resultMessage.content() : content;
    }

    public String extractThinking() {
        ResultMessage resultMessage = this.choices.get(0).getMessage();
        if (Objects.isNull(this.extractionTags)) {
            return resultMessage.reasoningContent();
        }
        return this.extractionTags.extractThinking(resultMessage.content());
    }

    public <T> T toObject(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return (T)Json.fromJson((String)this.extractContent(), clazz);
    }

    public AssistantMessage toAssistantMessage() {
        String thinking;
        String content;
        ResultMessage resultMessage = this.choices.get(0).getMessage();
        if (Objects.isNull(this.extractionTags)) {
            content = resultMessage.content();
            thinking = resultMessage.reasoningContent();
        } else {
            content = this.extractionTags.extractResponse(resultMessage.content());
            content = Objects.isNull(content) ? resultMessage.content() : content;
            thinking = this.extractionTags.extractThinking(resultMessage.content());
        }
        return new AssistantMessage(content, thinking, null, resultMessage.refusal(), resultMessage.toolCalls());
    }

    public FinishReason finishReason() {
        ResultChoice resultMessage = this.choices.get(0);
        return FinishReason.fromValue(resultMessage.getFinishReason());
    }

    public String toString() {
        return "ChatResponse [id=" + this.id + ", object=" + this.object + ", modelId=" + this.modelId + ", model=" + this.model + ", choices=" + String.valueOf(this.choices) + ", created=" + this.created + ", modelVersion=" + this.modelVersion + ", createdAt=" + this.createdAt + ", usage=" + String.valueOf(this.usage) + "]";
    }

    public static final class ResultChoice {
        private Integer index;
        private ResultMessage message;
        private String finishReason;

        public ResultChoice() {
        }

        public ResultChoice(Integer index, ResultMessage message, String finishReason) {
            this.index = index;
            this.message = message;
            this.finishReason = finishReason;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public ResultMessage getMessage() {
            return this.message;
        }

        public void setMessage(ResultMessage message) {
            this.message = message;
        }

        public String getFinishReason() {
            return this.finishReason;
        }

        public void setFinishReason(String finishReason) {
            this.finishReason = finishReason;
        }

        public String toString() {
            return "ResultChoice [index=" + this.index + ", message=" + String.valueOf(this.message) + ", finishReason=" + this.finishReason + "]";
        }
    }
}

