/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.Thinking;
import com.ibm.watsonx.ai.chat.model.ThinkingEffort;
import com.ibm.watsonx.ai.chat.model.Tool;
import java.util.List;
import java.util.Objects;

public final class ChatRequest {
    private final String deploymentId;
    private final List<ChatMessage> messages;
    private final List<Tool> tools;
    private final ChatParameters parameters;
    private final Thinking thinking;

    protected ChatRequest(Builder builder) {
        this.messages = Objects.requireNonNull(builder.messages, "messages cannot be null");
        this.tools = builder.tools;
        this.parameters = builder.parameters;
        this.deploymentId = builder.deploymentId;
        this.thinking = builder.thinking;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public ChatParameters getParameters() {
        return this.parameters;
    }

    public Thinking getThinking() {
        return this.thinking;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deploymentId;
        private List<ChatMessage> messages;
        private List<Tool> tools;
        private ChatParameters parameters;
        private Thinking thinking;

        private Builder() {
        }

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder messages(ChatMessage ... messages) {
            return this.messages(List.of(messages));
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder tools(Tool ... tools) {
            return this.tools(List.of(tools));
        }

        public Builder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        public Builder parameters(ChatParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder thinking(boolean enabled) {
            return this.thinking(Thinking.builder().enabled(enabled).build());
        }

        public Builder thinking(ExtractionTags tags) {
            if (Objects.isNull(tags)) {
                this.thinking = null;
                return this;
            }
            return this.thinking(Thinking.of(tags));
        }

        public Builder thinking(ThinkingEffort thinkingEffort) {
            if (Objects.isNull((Object)thinkingEffort)) {
                this.thinking = null;
                return this;
            }
            return this.thinking(Thinking.of(thinkingEffort));
        }

        public Builder thinking(Thinking thinking) {
            this.thinking = thinking;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this);
        }
    }
}

