/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai;

import com.ibm.watsonx.ai.CloudRegion;
import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.auth.iam.IAMAuthenticator;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;

public abstract class WatsonxService {
    protected static final String API_VERSION = "2025-10-01";
    protected static final String TRANSACTION_ID_HEADER = "X-Global-Transaction-Id";
    protected static final Duration TIME_OUT = Duration.ofSeconds(60L);
    protected final String baseUrl;
    protected final String version;
    protected final Duration timeout;
    protected final boolean logRequests;
    protected final boolean logResponses;

    protected WatsonxService(Builder<?> builder) {
        this.baseUrl = Objects.requireNonNull(builder.baseUrl, "The baseUrl must be provided");
        this.version = Objects.requireNonNullElse(builder.version, API_VERSION);
        this.timeout = Objects.requireNonNullElse(builder.timeout, TIME_OUT);
        this.logRequests = Objects.requireNonNullElse(builder.logRequests, false);
        this.logResponses = Objects.requireNonNullElse(builder.logResponses, false);
    }

    protected static abstract class Builder<T extends Builder<T>> {
        private String baseUrl;
        private String version;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private AuthenticationProvider authenticationProvider;

        protected Builder() {
        }

        public T baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (T)this;
        }

        public T baseUrl(URI baseUrl) {
            return this.baseUrl(baseUrl.toString());
        }

        public T baseUrl(CloudRegion baseUrl) {
            return this.baseUrl(baseUrl.getMlEndpoint());
        }

        public T version(String version) {
            this.version = version;
            return (T)this;
        }

        public T logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return (T)this;
        }

        public T logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return (T)this;
        }

        public T timeout(Duration timeout) {
            this.timeout = timeout;
            return (T)this;
        }

        public T apiKey(String apiKey) {
            Objects.requireNonNull(apiKey, "The apiKey must be provided");
            this.authenticationProvider = IAMAuthenticator.builder().apiKey(apiKey).build();
            return (T)this;
        }

        public T authenticationProvider(AuthenticationProvider authenticationProvider) {
            this.authenticationProvider = authenticationProvider;
            return (T)this;
        }

        public AuthenticationProvider getAuthenticationProvider() {
            return this.authenticationProvider;
        }
    }

    public static abstract class ModelService
    extends ProjectService {
        protected final String modelId;

        protected ModelService(Builder<?> builder) {
            super((ProjectService.Builder<?>)builder);
            this.modelId = Objects.requireNonNull(builder.modelId, "The modelId must be provided");
        }

        protected static abstract class Builder<T extends Builder<T>>
        extends ProjectService.Builder<T> {
            private String modelId;

            protected Builder() {
            }

            public T modelId(String modelId) {
                this.modelId = modelId;
                return (T)this;
            }
        }
    }

    public static abstract class ProjectService
    extends WatsonxService {
        protected final String projectId;
        protected final String spaceId;

        protected ProjectService(Builder<?> builder) {
            super(builder);
            this.projectId = builder.projectId;
            this.spaceId = builder.spaceId;
            if (Objects.isNull(this.projectId) && Objects.isNull(this.spaceId)) {
                throw new NullPointerException("Either projectId or spaceId must be provided");
            }
        }

        protected ProjectSpace resolveProjectSpace(WatsonxParameters parameters) {
            if (Objects.isNull(parameters)) {
                return new ProjectSpace(this.projectId, this.spaceId);
            }
            return Objects.nonNull(parameters.getProjectId()) || Objects.nonNull(parameters.getSpaceId()) ? new ProjectSpace(parameters.getProjectId(), parameters.getSpaceId()) : new ProjectSpace(this.projectId, this.spaceId);
        }

        protected static abstract class Builder<T extends Builder<T>>
        extends com.ibm.watsonx.ai.WatsonxService$Builder<T> {
            private String projectId;
            private String spaceId;

            protected Builder() {
            }

            public T projectId(String projectId) {
                this.projectId = projectId;
                return (T)this;
            }

            public T spaceId(String spaceId) {
                this.spaceId = spaceId;
                return (T)this;
            }
        }

        protected record ProjectSpace(String projectId, String spaceId) {
        }
    }
}

