/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai;

import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import java.time.Duration;
import java.util.Objects;

public abstract class WatsonxRestClient {
    public static final String TRANSACTION_ID_HEADER = "X-Global-Transaction-Id";
    protected final String baseUrl;
    protected final String version;
    protected final Duration timeout;
    protected final boolean logRequests;
    protected final boolean logResponses;
    protected final AuthenticationProvider authenticationProvider;

    protected WatsonxRestClient(Builder<?, ?> builder) {
        this.baseUrl = Objects.requireNonNull(builder.baseUrl, "The url must be provided");
        this.version = Objects.requireNonNull(builder.version, "The version must be provided");
        this.timeout = Objects.requireNonNull(builder.timeout, "The timeout must be provided");
        this.logRequests = Objects.requireNonNullElse(builder.logRequests, false);
        this.logResponses = Objects.requireNonNullElse(builder.logResponses, false);
        this.authenticationProvider = builder.authenticationProvider;
    }

    protected static abstract class Builder<T, B extends Builder<T, B>> {
        private String baseUrl;
        private String version;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        protected AuthenticationProvider authenticationProvider;

        protected Builder() {
        }

        public abstract T build();

        public B baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (B)this;
        }

        public B version(String version) {
            this.version = version;
            return (B)this;
        }

        public B logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return (B)this;
        }

        public B logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return (B)this;
        }

        public B timeout(Duration timeout) {
            this.timeout = timeout;
            return (B)this;
        }

        public B authenticationProvider(AuthenticationProvider authenticationProvider) {
            this.authenticationProvider = authenticationProvider;
            return (B)this;
        }
    }
}

