/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class PullBatchesOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected String batchId;

    protected PullBatchesOptions() {
    }

    protected PullBatchesOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notEmpty((String)builder.batchId, (String)"batchId cannot be empty");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.batchId = builder.batchId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String batchId() {
        return this.batchId;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private String batchId;

        private Builder(PullBatchesOptions pullBatchesOptions) {
            this.projectId = pullBatchesOptions.projectId;
            this.collectionId = pullBatchesOptions.collectionId;
            this.batchId = pullBatchesOptions.batchId;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId, String batchId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
            this.batchId = batchId;
        }

        public PullBatchesOptions build() {
            return new PullBatchesOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder batchId(String batchId) {
            this.batchId = batchId;
            return this;
        }
    }
}

