/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.WebhookHeader;
import java.util.ArrayList;
import java.util.List;

public class EnrichmentOptions
extends GenericModel {
    protected List<String> languages;
    @SerializedName(value="entity_type")
    protected String entityType;
    @SerializedName(value="regular_expression")
    protected String regularExpression;
    @SerializedName(value="result_field")
    protected String resultField;
    @SerializedName(value="classifier_id")
    protected String classifierId;
    @SerializedName(value="model_id")
    protected String modelId;
    @SerializedName(value="confidence_threshold")
    protected Double confidenceThreshold;
    @SerializedName(value="top_k")
    protected Long topK;
    protected String url;
    protected String version;
    protected String secret;
    protected WebhookHeader headers;
    @SerializedName(value="location_encoding")
    protected String locationEncoding;

    protected EnrichmentOptions() {
    }

    protected EnrichmentOptions(Builder builder) {
        this.languages = builder.languages;
        this.entityType = builder.entityType;
        this.regularExpression = builder.regularExpression;
        this.resultField = builder.resultField;
        this.classifierId = builder.classifierId;
        this.modelId = builder.modelId;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.topK = builder.topK;
        this.url = builder.url;
        this.version = builder.version;
        this.secret = builder.secret;
        this.headers = builder.headers;
        this.locationEncoding = builder.locationEncoding;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> languages() {
        return this.languages;
    }

    public String entityType() {
        return this.entityType;
    }

    public String regularExpression() {
        return this.regularExpression;
    }

    public String resultField() {
        return this.resultField;
    }

    public String classifierId() {
        return this.classifierId;
    }

    public String modelId() {
        return this.modelId;
    }

    public Double confidenceThreshold() {
        return this.confidenceThreshold;
    }

    public Long topK() {
        return this.topK;
    }

    public String url() {
        return this.url;
    }

    public String version() {
        return this.version;
    }

    public String secret() {
        return this.secret;
    }

    public WebhookHeader headers() {
        return this.headers;
    }

    public String locationEncoding() {
        return this.locationEncoding;
    }

    public static class Builder {
        private List<String> languages;
        private String entityType;
        private String regularExpression;
        private String resultField;
        private String classifierId;
        private String modelId;
        private Double confidenceThreshold;
        private Long topK;
        private String url;
        private String version;
        private String secret;
        private WebhookHeader headers;
        private String locationEncoding;

        private Builder(EnrichmentOptions enrichmentOptions) {
            this.languages = enrichmentOptions.languages;
            this.entityType = enrichmentOptions.entityType;
            this.regularExpression = enrichmentOptions.regularExpression;
            this.resultField = enrichmentOptions.resultField;
            this.classifierId = enrichmentOptions.classifierId;
            this.modelId = enrichmentOptions.modelId;
            this.confidenceThreshold = enrichmentOptions.confidenceThreshold;
            this.topK = enrichmentOptions.topK;
            this.url = enrichmentOptions.url;
            this.version = enrichmentOptions.version;
            this.secret = enrichmentOptions.secret;
            this.headers = enrichmentOptions.headers;
            this.locationEncoding = enrichmentOptions.locationEncoding;
        }

        public Builder() {
        }

        public EnrichmentOptions build() {
            return new EnrichmentOptions(this);
        }

        public Builder addLanguages(String languages) {
            Validator.notNull((Object)languages, (String)"languages cannot be null");
            if (this.languages == null) {
                this.languages = new ArrayList<String>();
            }
            this.languages.add(languages);
            return this;
        }

        public Builder languages(List<String> languages) {
            this.languages = languages;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder regularExpression(String regularExpression) {
            this.regularExpression = regularExpression;
            return this;
        }

        public Builder resultField(String resultField) {
            this.resultField = resultField;
            return this;
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        public Builder topK(long topK) {
            this.topK = topK;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder headers(WebhookHeader headers) {
            this.headers = headers;
            return this;
        }

        public Builder locationEncoding(String locationEncoding) {
            this.locationEncoding = locationEncoding;
            return this;
        }
    }
}

