/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.CreateEnrichment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateEnrichmentOptions
extends GenericModel {
    protected String projectId;
    protected CreateEnrichment enrichment;
    protected InputStream file;

    protected CreateEnrichmentOptions() {
    }

    protected CreateEnrichmentOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notNull((Object)((Object)builder.enrichment), (String)"enrichment cannot be null");
        this.projectId = builder.projectId;
        this.enrichment = builder.enrichment;
        this.file = builder.file;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public CreateEnrichment enrichment() {
        return this.enrichment;
    }

    public InputStream file() {
        return this.file;
    }

    public static class Builder {
        private String projectId;
        private CreateEnrichment enrichment;
        private InputStream file;

        private Builder(CreateEnrichmentOptions createEnrichmentOptions) {
            this.projectId = createEnrichmentOptions.projectId;
            this.enrichment = createEnrichmentOptions.enrichment;
            this.file = createEnrichmentOptions.file;
        }

        public Builder() {
        }

        public Builder(String projectId, CreateEnrichment enrichment) {
            this.projectId = projectId;
            this.enrichment = enrichment;
        }

        public CreateEnrichmentOptions build() {
            return new CreateEnrichmentOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder enrichment(CreateEnrichment enrichment) {
            this.enrichment = enrichment;
            return this;
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            return this;
        }
    }
}

