/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.CollectionDetailsSmartDocumentUnderstanding;
import com.ibm.watson.discovery.v2.model.CollectionEnrichment;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CollectionDetails
extends GenericModel {
    @SerializedName(value="collection_id")
    protected String collectionId;
    protected String name;
    protected String description;
    protected Date created;
    protected String language;
    @SerializedName(value="ocr_enabled")
    protected Boolean ocrEnabled;
    protected List<CollectionEnrichment> enrichments;
    @SerializedName(value="smart_document_understanding")
    protected CollectionDetailsSmartDocumentUnderstanding smartDocumentUnderstanding;

    protected CollectionDetails() {
    }

    protected CollectionDetails(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.name = builder.name;
        this.description = builder.description;
        this.language = builder.language;
        this.ocrEnabled = builder.ocrEnabled;
        this.enrichments = builder.enrichments;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Date created() {
        return this.created;
    }

    public String language() {
        return this.language;
    }

    public Boolean ocrEnabled() {
        return this.ocrEnabled;
    }

    public List<CollectionEnrichment> enrichments() {
        return this.enrichments;
    }

    public CollectionDetailsSmartDocumentUnderstanding smartDocumentUnderstanding() {
        return this.smartDocumentUnderstanding;
    }

    public static class Builder {
        private String name;
        private String description;
        private String language;
        private Boolean ocrEnabled;
        private List<CollectionEnrichment> enrichments;

        private Builder(CollectionDetails collectionDetails) {
            this.name = collectionDetails.name;
            this.description = collectionDetails.description;
            this.language = collectionDetails.language;
            this.ocrEnabled = collectionDetails.ocrEnabled;
            this.enrichments = collectionDetails.enrichments;
        }

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public CollectionDetails build() {
            return new CollectionDetails(this);
        }

        public Builder addEnrichments(CollectionEnrichment enrichments) {
            Validator.notNull((Object)((Object)enrichments), (String)"enrichments cannot be null");
            if (this.enrichments == null) {
                this.enrichments = new ArrayList<CollectionEnrichment>();
            }
            this.enrichments.add(enrichments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder ocrEnabled(Boolean ocrEnabled) {
            this.ocrEnabled = ocrEnabled;
            return this;
        }

        public Builder enrichments(List<CollectionEnrichment> enrichments) {
            this.enrichments = enrichments;
            return this;
        }
    }
}

